package kawigi.language;

/**
 *	Creates EditorLanguage objects based on a language name or filetype.
 *	
 *	This class was really simple at some point in time and returned TopCoder
 *	languages.  Then I wanted to associate more data with languages, so I
 *	subclassed all the TopCoder languages and made this class return those.
 *	Then I wanted the template code generated by those subclassed languages
 *	to be customizable by allowing the user to indirectly write their own
 *	subclass of my subclassed languages, and this class became this gigantic
 *	monstrosity of dynamic class-loading.
 *	
 *	Then I wanted to make it so that KawigiEdit could be run standalone without
 *	having the TopCoder classes in the classpath, and this class was made simple
 *	again, just returning elements from my EditorLanguage enum.  Actually, the
 *	only remaining use of this class is to figure out which language to use to
 *	render code opened in the Local Code tab, which probably means it's not
 *	worth this long comment.  It isn't even used to map TC languages to
 *	KawigiEdit EditorLanguages, because that would require linking to TopCoder
 *	classes, and this class needs to be usable in standalone mode.
 **/
public class LanguageFactory
{
	/**
	 *	Returns the EditorLanguage with the given name, or that supports the
	 *	file extension given by name.
	 **/
	public static EditorLanguage getLanguage(String name)
	{
		if (name.equalsIgnoreCase("java"))
			return EditorLanguage.Java;
		// a small subset of names and file extensions that should use the C++
		// language objects - less than there are, more than I really need.
		else if (name.equalsIgnoreCase("cpp") || name.equalsIgnoreCase("c++") || name.equalsIgnoreCase("h") || name.equalsIgnoreCase("c") || name.equalsIgnoreCase("cxx"))
			return EditorLanguage.CPP;
		else if (name.equalsIgnoreCase("csharp") || name.equalsIgnoreCase("c#") || name.equalsIgnoreCase("cs"))
			return EditorLanguage.CSharp;
		else if (name.equalsIgnoreCase("vb") || name.equalsIgnoreCase("bas") || name.equalsIgnoreCase("basic"))
			return EditorLanguage.VB;
		return null;
	}
}
