package kawigi.language;
import kawigi.problem.*;

public class CSharpTestGenerator implements TestGenerator
{
	/**
	 *	Returns C# testing code for the problem statement's example test cases.
	 **/
	public String getCode(ClassDecl cl)
	{
		String testcode = "\t#region Testing code generated by KawigiEdit\n";
		testcode += "\t[STAThread]\n";
		testcode += "\tpublic static void Main(string[] args)\n\t{\n";
		EditorDataType returnType = cl.getMethod().getReturnType();
		testcode += "\t\t" + EditorLanguage.CSharp.getName(returnType) + " answer, desiredAnswer;\n";
		testcode += "\t\tbool errors = false;\n";
		if (returnType.isArrayType())
			testcode += "\t\tbool same;\n";
		boolean stringType = returnType.isType(EditorDataType.String);
		testcode += "\t\tDateTime time;\n";
		testcode += "\t\t<%:start-tests%>\n";
		for (int i=0; i<cl.countTests(); i++)
		{
			testcode += "\t\ttime = DateTime.Now;\n";
			testcode += "\t\tanswer = new " + cl.getName() + "()." + cl.getMethod().getName() + "(" + toTest(cl.getTest(i), cl.getMethod().getParamTypes()) + ");\n";
			testcode += "\t\tConsole.WriteLine(\"Time: \" + (DateTime.Now-time).TotalSeconds + \" seconds\");\n";
			testcode += "\t\tdesiredAnswer = " + translateObject(returnType, cl.getTest(i).getAnswer()) + ";\n";
			testcode += "\t\tConsole.WriteLine(\"Your answer:\");\n";
			//If writing code that writes code isn't confusing enough, maybe writing code that writes code that writes code-like constructs is
			if (returnType.isArrayType())
			{
				testcode += "\t\tif (answer.Length > 0)\n";
				testcode += "\t\t{\n";
				testcode += "\t\t\tConsole.Write(\"\\t{ " + (stringType ? "\\\"\" + answer[0] + \"\\\"\"" : "\" + answer[0]") + ");\n";
				testcode += "\t\t\tfor (int i=1; i<answer.Length; i++)\n";
				testcode += "\t\t\t\tConsole.Write(\"," + (stringType ? "\\n\\t  \\\"" : " ") + "\" + answer[i]" + (stringType ? " + \"\\\"\"": "") + ");\n";
				testcode += "\t\t\tConsole.WriteLine(\" }\");\n";
				testcode += "\t\t}\n";
				testcode += "\t\telse\n";
				testcode += "\t\t\tConsole.WriteLine(\"\\t{ }\");\n";
				testcode += "\t\tConsole.WriteLine(\"Desired answer:\");\n";
				testcode += "\t\tif (desiredAnswer.Length > 0)\n";
				testcode += "\t\t{\n";
				testcode += "\t\t\tConsole.Write(\"\\t{ " + (stringType ? "\\\"\" + desiredAnswer[0] + \"\\\"\"" : "\" + desiredAnswer[0]") + ");\n";
				testcode += "\t\t\tfor (int i=1; i<desiredAnswer.Length; i++)\n";
				testcode += "\t\t\t\tConsole.Write(\"," + (stringType ? "\\n\\t  \\\"" : " ") + "\" + desiredAnswer[i]" + (stringType ? " + \"\\\"\"": "") + ");\n";
				testcode += "\t\t\tConsole.WriteLine(\" }\");\n";
				testcode += "\t\t}\n";
				testcode += "\t\telse\n";
				testcode += "\t\t\tConsole.WriteLine(\"\\t{ }\");\n";
				testcode += "\t\tsame = (desiredAnswer.Length == answer.Length);\n";
				testcode += "\t\tfor (int i=0; i<answer.Length && same; i++)\n";
				testcode += "\t\t\tif (answer[i] != desiredAnswer[i])\n";
				testcode += "\t\t\t\tsame = false;\n";
				testcode += "\t\tif (!same)\n";
			}
			else
			{
				testcode += "\t\tConsole.WriteLine(\"\\t" + (stringType ? "\\\"" : "") + "\" + answer" + (stringType ? " + \"\\\"\"" : "") + ");\n";
				testcode += "\t\tConsole.WriteLine(\"Desired answer:\");\n";
				testcode += "\t\tConsole.WriteLine(\"\\t" + (stringType ? "\\\"" : "") + "\" + desiredAnswer" + (stringType ? " + \"\\\"\"" : "") + ");\n";
				testcode += "\t\tif (answer != desiredAnswer)\n";
			}
			testcode += "\t\t{\n";
			testcode += "\t\t\terrors = true;\n";
			testcode += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\");\n";
			testcode += "\t\t}\n";
			testcode += "\t\telse\n";
			testcode += "\t\t\tConsole.WriteLine(\"Match :-)\");\n";

			testcode += "\t\tConsole.WriteLine();\n";
		}
		testcode += "\t\t<%:end-tests%>\n";
		testcode += "\t\t\n\t\tif (errors)\n";
		testcode += "\t\t\tConsole.WriteLine(\"Some of the test cases had errors :-(\");\n";
		testcode += "\t\telse\n";
		testcode += "\t\t\tConsole.WriteLine(\"You're a stud (at least on the test data)! :-D \");\n";
		testcode += "\t}\n";
		testcode += "\t#endregion\n";
		return testcode;
	}
	
	
	/**
	 *	Quick utility function to provide the code that should return the answer.
	 **/
	protected String toTest(Test test, EditorDataType[] types)
	{
		String ret = "";
		String[] input = test.getParameters();
		ret += translateObject(types[0], input[0]);
		for (int i=1; i<input.length; i++)
			ret += ", " + translateObject(types[i], input[i]);
		ret = ret.replaceAll("\\n", "");
		// The Microsoft C# compiler has a weird line-length limit of 2046.
		// String arrays could screw this up.
		if (ret.length() > 2000)
		{
			String newret = "";
			boolean inQuotes = false;
			for (int i=0; i<ret.length(); i++)
			{
				newret += ret.charAt(i);
				if (ret.charAt(i) == '\\')
				{
					i++;
					newret += ret.charAt(i);
				}
				else if (ret.charAt(i) == '\"')
				{
					inQuotes = !inQuotes;
				}
				else if (ret.charAt(i) == ',' && !inQuotes)
				{
					newret += '\n';
				}
			}
			ret = newret;
		}
		return ret;
	}
	
	/**
	 *	Quck utility function to convert a value to code that creates that value
	 *	in C#.
	 **/
	protected static String translateObject(EditorDataType type, String value)
	{
		if (type.isArrayType())
			return "new " + EditorLanguage.CSharp.getName(type) + EditorLanguage.CSharp.fixLiteral(value, type);
		else
			return EditorLanguage.CSharp.fixLiteral(value, type);
	}
}
