package kawigi.util;
import com.topcoder.client.contestApplet.common.LocalPreferences;

/**
 *	Waits for the number of seconds specified in the configuration and then abruptly stops the process
 *	if it hasn't already ended.
 **/
public class KillThread extends Thread
{
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.timeout") == null)
			prefs.setProperty("kawigi.timeout", "15");
	}
	
	private ProcessContainer proc;
	
	/**
	 *	Creates a new KillThread to monitor proc.
	 **/
	public KillThread(ProcessContainer proc)
	{
		this.proc = proc;
	}
	
	/**
	 *	Waits for a certain number of seconds and then kills the process if it is not yet finished.
	 **/
	public synchronized void run()
	{
		int timeout = LocalPreferences.getInstance().getFontSize("kawigi.timeout");
		if (currentThread() == this)
			try
			{
				wait(timeout*1000);
			}
			catch (InterruptedException ex)
			{
			}
		if (!proc.isDone())
		{
			proc.kill();
			proc.println("Process Timed Out!!");
		}
	}
}