package kawigi.timer;

public class ProblemTimingInfo
{
	private double points;
	private long startTime;
	private int ID;
	private int contestLength;
	
	public ProblemTimingInfo(double points, long startTime, int problemID)
	{
		this.points = points;
		this.startTime = startTime;
		ID = problemID;
		contestLength = 75*60*1000;
	}
	
	public double getPoints()
	{
		return points;
	}
	
	public int getProblemID()
	{
		return ID;
	}
	
	public long getStartTime()
	{
		return startTime;
	}
	
	public void setContestLength(int minutes)
	{
		contestLength = minutes*60*1000;
	}
	
	public double currentScore()
	{
		long soFar = System.currentTimeMillis()-startTime;
		double score = points*(.3 + .7*contestLength*contestLength/(10.0*soFar*soFar + (double)contestLength*contestLength));
		return score;
	}
}
