package kawigi.template;
import java.util.*;

/**
 *	A class that keeps a list of Templatable classes.
 **/
public class TemplateManager
{
	/**
	 *	A Map of templatable thingies.
	 **/
	private static Map templatableMap = new HashMap();
	
	/**
	 *	Adds a Templatable object to the template manager.
	 *	
	 *	This is normally called from the static constructor of the Templatable classes.
	 **/
	public static void register(String name, Templatable templatable)
	{
		templatableMap.put(name, templatable);
	}
	
	/**
	 *	Gets a templatable object by name.  The name will correspond to a Template object.
	 **/
	public static Templatable getTemplatable(String name)
	{
		return (Templatable)templatableMap.get(name);
	}
	
	/**
	 *	Returns the set of strings that are the names of the templatable objects.
	 **/
	public static Set getKeys()
	{
		return templatableMap.keySet();
	}
}