package kawigi.template;

/**
 *	Interface for classes that can be extended by templates.
 **/
public interface Templatable
{
	/**
	 *	Returns the KTT template representing how this class is templated.
	 **/
	public Template getTemplate();
	
	/**
	 *	Returns a library of tags that may come in useful for writing templates extending this class.
	 **/
	public TagLibrary getNativeTagLibrary();
	
	/**
	 *	Returns the text of a default template.
	 **/
	public String getDefaultTemplateCode();
}