package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import javax.swing.text.*;
import java.io.File;
import java.util.*;
import java.lang.reflect.*;

/**
 *	Encapsulates a language with both KawigiEdit features and TC Language features.
 **/
public class ProxyLanguage implements InvocationHandler
{
	private Object obj;
	
	/**
	 *	Constructs a new Proxy for <code>obj</code>, which is an unstable instance of ExtendedLanguage.
	 **/
	protected ProxyLanguage(Object lang)
	{
		obj = lang;
	}
	
	/**
	 *	Creates a proxy instance that should theoretically be usable as an ExtendedLanguage.
	 **/
	public static Object newProxy(Object obj, ClassLoader loader) throws Exception
	{
		return Proxy.newProxyInstance(ProxyLanguage.class.getClassLoader(), new Class[]{ExtendedLanguage.class}, new ProxyLanguage(obj));
	}
	
	/**
	 *	Invokes the method on the original object.
	 **/
	public Object invoke(Object proxy, Method m, Object[] args) throws Throwable
	{
		Method[] ms = obj.getClass().getMethods();
		for (int i=0; i<ms.length; i++)
			if (ms[i].getName().equals(m.getName()) && ms[i].getParameterTypes().length == m.getParameterTypes().length)
				try
				{
					Object ret = ms[i].invoke(obj, args);
					if (ret.getClass().getName().equals("kawigi.language.Skeleton"))
						return new Skeleton((String)ret.getClass().getMethod("getSource", new Class[0]).invoke(ret, new Object[0]), ((Integer)ret.getClass().getMethod("getCaret", new Class[0]).invoke(ret, new Object[0])).intValue());
					else
						return ret;
				}
				catch (Exception ex)
				{
					ex.printStackTrace();
				}
		return null;
	}
}