package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import java.io.*;
import java.util.*;

/**
 *	This is a default implementation of ExtendedLanguage that contains a Language and routes all TC
 *	language features to it.
 **/
public abstract class LanguageContainer implements ExtendedLanguage, Serializable
{
	/**
	 *	The TC language related to this Object.
	 **/
	protected Language baselang;
	
	/**
	 *	Constructs a new LanguageContainer that forwards several method calls to <code>lang</code>.
	 **/
	public LanguageContainer(Language lang)
	{
		baselang = lang;
	}
	
	/**
	 *	Returns the TopCoder Language object that this one is built on top of.
	 **/
	public Language getBaseLanguage()
	{
		return baselang;
	}
 	
	/**
	 *	TopCoder-related custom serialization dealy.
	 **/
	public void customReadObject(CSReader reader) throws IOException
	{
		baselang.customReadObject(reader);
	}
	
	/**
	 *	Another TopCoder-related custom serialization dealy.
	 **/
	public void customWriteObject(CSWriter writer) throws IOException
	{
		baselang.customWriteObject(writer);
	}
	
	/**
	 *	Determines if <code>o</code> is an equivalent language to this object.
	 **/
	public boolean equals(java.lang.Object o)
	{
		return (o instanceof Language) && ((Language)o).getId() == getId();
	}
	
	/**
	 *	Returns the integer ID of the language represented by this object.
	 **/
	public int getId()
	{
		return baselang.getId();
	}
	
	/**
	 *	Returns the method signature for this language from the TC Language object.
	 **/
	public String getMethodSignature(String methodName, DataType returnType, DataType[] paramTypes, String[] paramNames)
	{
		return baselang.getMethodSignature(methodName, returnType, paramTypes, paramNames);
	}
	
	/**
	 *	Returns the name of this language from the TC Language object.
	 **/
	public String getName()
	{
		return baselang.getName();
	}
	
	/**
	 *	Returns the property subclass that settings for this language will be stored in.
	 *	
	 *	By default, this is the name of the language in lower case.
	 **/
	public String getPropertyClass()
	{
		return getName().toLowerCase();
	}
}