package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import javax.swing.text.*;
import java.io.File;
import kawigi.editor.*;
import kawigi.template.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

/**
 *	VisualBasic implementation of the ExtendedLanguage interface.
 **/
public class ExtendedVBLanguage extends LanguageContainer implements Templatable
{
	/**
	 *	A singleton instance of the extended Visual Basic language, sort of like how TC does it.
	 **/
	public static final ExtendedVBLanguage EXTENDED_VB_LANGUAGE = new ExtendedVBLanguage();
	
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".filename") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".filename", "$PROBLEM$.vb");
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".compiler") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".compiler", "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\vbc.exe\" $PROBLEM$.vb");
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".run") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".run", "\"$CWD$" + File.separator + "$PROBLEM$.exe\"");
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".imports") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".imports", "Microsoft.VisualBasic,System,System.Collections,System.Text");
		TemplateManager.register("Visual Basic Template", EXTENDED_VB_LANGUAGE);
	}
	/**
	 *	Creates a new instance of the ExtendedLanguage that uses settings from the given TC Language.
	 *	
	 *	This object will behave strangely if lang is not a VBLanguage instance.
	 **/
	public ExtendedVBLanguage(Language lang)
	{
		super(lang);
	}
	
	/**
	 *	Creates a new instance of the ExtendedLanguage that uses TC's singleton VB language instance.
	 **/
	public ExtendedVBLanguage()
	{
		super(VBLanguage.VB_LANGUAGE);
	}
	
	/**
	 *	Returns at a class and method declaration, with a main method that has testing code.
	 *	
	 *	As some of my first Visual Basic code comes out of this method, I wouldn't be offended
	 *	if someone else came and reimplemented it, but it at least seems to generate <i>correct</i>
	 *	code, so we'll leave it at that for now.
	 **/
	public Skeleton getSkeleton(ProblemComponent comp)
	{
		caret = 0;
		return new Skeleton(getTemplateCode(comp, this), caret);
	}
	
	/**
	 *	The templatable method for Visual Basic templates.
	 **/
	public String getTemplateCode(ProblemComponent comp, Language lang)
	{
		String skeleton = "";
		LocalPreferences prefs = LocalPreferences.getInstance();
		String[] imports = prefs.getProperty("kawigi.language." + getPropertyClass() + ".imports").split(",");
		for (int i=0; i<imports.length; i++)
			skeleton += "Imports " + imports[i] + "\n";
		skeleton += "\nPublic Class " + comp.getClassName() + "\n";
		skeleton += "\tPublic Function " + comp.getMethodName() + "(";
		skeleton += makeParamList(comp.getParamTypes(), comp.getParamNames(), "ByVal");
		skeleton += ") As " + comp.getReturnType().getDescriptor(lang) + "\n\t\t\n";
		caret = skeleton.length()-1;
		skeleton += "\tEnd Function\n";
		skeleton += "End Class\n\n";
		skeleton += generateTestingCode(comp, lang);
		skeleton += "\n'Powered by [KawigiEdit]\n";
		return skeleton;
	}
	
	/**
	 *	Used to set the caret location in the code template.
	 **/
	protected int caret;	
		
	/**
	 *	Returns the testing code for the problem statement's default testing cases.
	 **/
	protected String generateTestingCode(ProblemComponent comp, Language lang)
	{
		String testcode = "#Region \"Testing code generated by KawigiEdit\"\n";
		testcode += "Module MainModule\n";
		testcode += "\tSub Main()\n";
		TestCase[] cases = comp.getTestCases();
		String returnType = comp.getReturnType().getDescriptor(lang);
		testcode += "\t\tDim Errors As Boolean = False\n";
		testcode += "\t\tDim Answer, DesiredAnswer As " + returnType + "\n";
		testcode += "\t\tDim Obj As " + comp.getClassName() + "\n";
		testcode += "\t\tDim Time As DateTime\n";
		if (returnType.endsWith("()"))
		{
			testcode += "\t\tDim Same As Boolean\n";
			testcode += "\t\tDim i As Integer\n";
		}
		boolean stringType = returnType.startsWith("String");
		DataType[] paramTypes = comp.getParamTypes();
		for (int i=0; i<cases.length; i++)
		{
			testcode += "\t\tObj = New " + comp.getClassName() + "()\n";
			testcode += "\t\tTime = DateTime.Now\n";
			testcode += "\t\tAnswer = Obj." + comp.getMethodName() + "(" + toTest(cases[i], paramTypes) + ")\n";
			testcode += "\t\tConsole.WriteLine(\"Time: \" & (DateTime.Now.Subtract(Time)).TotalSeconds & \" seconds\")\n";
			testcode += "\t\tDesiredAnswer = " + translateObject(returnType, cases[i].getOutput()) + "\n";
			testcode += "\t\tConsole.WriteLine(\"Your Answer:\")\n";
			if (returnType.endsWith("()"))
			{
				testcode += "\t\tConsole.Write(\"{ \")\n";
				testcode += "\t\tIf (Answer.Length > 0) Then\n";
				testcode += "\t\t\tConsole.Write(" + (stringType ? "\"\"\"\" & " : "") + "Answer(0)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				testcode += "\t\t\tFor i = 1 To Answer.Length - 1\n";
				testcode += "\t\t\t\tConsole.Write(\"\t, " + (stringType ? "\"\"" : "") + "\" & Answer(i)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				testcode += "\t\t\tNext\n";
				testcode += "\t\t\tConsole.WriteLine(\" }\")\n";
				testcode += "\t\tElse\n";
				testcode += "\t\t\tConsole.WriteLine(\"}\")\n";
				testcode += "\t\tEnd If\n";
				testcode += "\t\tConsole.WriteLine(\"Desired Answer:\")\n";
				testcode += "\t\tConsole.Write(\"{ \")\n";
				testcode += "\t\tSame = (Answer.Length = DesiredAnswer.Length)\n";
				testcode += "\t\tIf (Answer.Length > 0) Then\n";
				testcode += "\t\t\tConsole.Write(" + (stringType ? "\"\"\"\" & " : "") + "DesiredAnswer(0)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				testcode += "\t\t\tIf Answer(0) <> DesiredAnswer(0) Then\n";
				testcode += "\t\t\t\tSame = False\n";
				testcode += "\t\t\tEnd If\n";
				testcode += "\t\t\tFor i = 1 To DesiredAnswer.Length - 1\n";
				testcode += "\t\t\t\tConsole.Write(\"\t, " + (stringType ? "\"\"" : "") + "\" & DesiredAnswer(i)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				testcode += "\t\t\t\tIf Answer(i) <> DesiredAnswer(i) Then\n";
				testcode += "\t\t\t\t\tSame = False\n";
				testcode += "\t\t\t\tEnd If\n";
				testcode += "\t\t\tNext\n";
				testcode += "\t\t\tConsole.WriteLine(\" }\")\n";
				testcode += "\t\tElse\n";
				testcode += "\t\t\tConsole.WriteLine(\"}\")\n";
				testcode += "\t\tEnd If\n";
				testcode += "\t\tIf Same Then\n";
				testcode += "\t\t\tConsole.WriteLine(\"Match :-)\")\n";
				testcode += "\t\tElse\n";
				testcode += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\")\n";
				testcode += "\t\t\tErrors = True\n";
				testcode += "\t\tEnd If\n";
			}
			else
			{
				testcode += "\t\tConsole.WriteLine(\"\t" + (stringType ? "\"\"" : "") + "\" & Answer" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				testcode += "\t\tConsole.WriteLine(\"Desired Answer:\")\n";
				testcode += "\t\tConsole.WriteLine(\"\t" + (stringType ? "\"\"" : "") +"\" & DesiredAnswer" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				testcode += "\t\tIf Answer = DesiredAnswer Then\n";
				testcode += "\t\t\tConsole.WriteLine(\"Match :-)\")\n";
				testcode += "\t\tElse\n";
				testcode += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\")\n";
				testcode += "\t\t\tErrors = True\n";
				testcode += "\t\tEnd If\n";
			}
			testcode += "\t\tConsole.WriteLine()\n";
		}
		testcode += "\t\t\n\t\tIf Errors Then\n";
		testcode += "\t\t\tConsole.WriteLine(\"Some of the test cases had errors :-(\")\n";
		testcode += "\t\tElse\n";
		testcode += "\t\t\tConsole.WriteLine(\"You're a stud (at least on the test data)! :-D \")\n";
		testcode += "\t\tEnd If\n";
		testcode += "\tEnd Sub\n";
		testcode += "End Module\n";
		testcode += "#End Region\n";
		return testcode;
	}
	
	/**
	 *	Quick utility function to provide the code that should return the parameter list for the function.
	 **/
	protected String toTest(TestCase test, DataType[] types)
	{
		String[] input = test.getInput();
		String ret = translateObject(types[0].getDescriptor(this), input[0]);
		for (int i=1; i<input.length; i++)
			ret += ", " + translateObject(types[i].getDescriptor(this), input[i]);
		ret = ret.replaceAll("\\n", "");
		return ret;
	}
	
	/**
	 *	Quck utility function to convert a string value from TC to code that creates that value in VB.
	 **/
	protected static String translateObject(String type, String value)
	{
		if (type.endsWith("()"))
			return "New " + type + value;
		else
			return value;
	}
	
	/**
	 *	Returns a string in the format <type> <name>, <type> <name>, etc.
	 **/
	protected String makeParamList(DataType[] types, String[] names, String passing)
	{
		String ret = "";
		for (int i=0; i<types.length; i++)
		{
			if (i > 0)
				ret += ", ";
			ret += passing + " " + names[i] + " As " + types[i].getDescriptor(this);
		}
		return ret;
	}
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.  And how platform-independent is Microsoft Visual Basic .NET, anyways?
	 **/
	public String getCompileCommand(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".compiler";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\vbc.exe\" $PROBLEM$.vb");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".run";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"$CWD$" + File.separator + "$PROBLEM$");
		command = command.replaceAll("\\$CWD\\$", cwd.getPath().replaceAll("\\\\", "\\\\\\\\"));
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".filename";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "$PROBLEM$.vb");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the class of the VB implementation of a View
	 **/
	public Class getViewClass()
	{
		return VBView.class;
	}
	
	/**
	 *	Returns the KTT template representing how this class is templated.
	 **/
	public Template getTemplate()
	{
		return new Template(getClass().getName(), "getTemplateCode", new String[]{"com.topcoder.shared.problem.ProblemComponent comp", "com.topcoder.shared.language.Language lang"});
	}
	
	/**
	 *	Returns a library of tags that may come in useful for writing templates extending this class.
	 **/
	public TagLibrary getNativeTagLibrary()
	{
		TagLibrary taglib = new TagLibrary();
		taglib.addMethod("class-name", new String[0], new String[]{"code += comp.getClassName();"});
		taglib.addMethod("method-name", new String[0], new String[]{"code += comp.getMethodName();"});
		taglib.addMethod("return-type", new String[0], new String[]{"code += comp.getReturnType().getDescriptor(lang);"});
		taglib.addMethod("byval-param-list", new String[0], new String[]{"code += makeParamList(comp.getParamTypes(), comp.getParamNames(), \"ByVal\");"});
		taglib.addMethod("byref-param-list", new String[0], new String[]{"code += makeParamList(comp.getParamTypes(), comp.getParamNames(), \"ByRef\");"});
		taglib.addMethod("testing-code", new String[0], new String[]{"code += generateTestingCode(comp, lang);"});
		taglib.addMethod("set-caret", new String[0], new String[]{"caret = code.length();"});
		return taglib;
	}
	
	/**
	 *	Returns the text of a default template.
	 **/
	public String getDefaultTemplateCode()
	{
		return	"<%!include " + getClass().getName() + " %>\n"
			+	"Imports Microsoft.VisualBasic\n"
			+	"Imports System\n"
			+	"Imports System.Collections\n"
			+	"Imports System.Text\n\n"
			+	"Public Class <%:class-name%>\n"
			+	"\tPublic Function<%:method-name%>(<%:byref-param-list%>) As <%:return-type%>\n"
			+	"\t\t<%:set-caret%>\n"
			+	"\tEnd Function\n\n"
			+	"End Class\n"
			+	"<%:testing-code%>\n"
			+	"'Powered by [KawigiEdit]\n";
	}
}
