package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.reflect.*;

/**
 *	A quick way to get the right ExtendedLanguage object for your needs.
 **/
public class ExtendedLanguageFactory
{
	/**
	 *	Creates an Extended Language of the type given in the language id.
	 **/
	public static synchronized ExtendedLanguage getLanguage(int languageid)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		File folder = new File(prefs.getProperty("kawigi.localpath"));
		ArrayList urls = new ArrayList();
		URLClassLoader classLoader = null;
		try
		{
			urls.add(folder.toURL());
			if (prefs.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.commonclasspath") != null && prefs.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.commonclasspath").length() > 0)
			{
				StringTokenizer pathTok = new StringTokenizer(prefs.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.commonclasspath"), File.pathSeparator);
				while (pathTok.hasMoreTokens())
					urls.add(new File(pathTok.nextToken()).toURL());
			}
			for (int i=1; i<= Integer.parseInt(prefs.getProperty("editor.numplugins")); i++)
			{
				if (prefs.getProperty("editor." + i + ".entrypoint").equals("kawigi.KawigiEdit"))
				{
					StringTokenizer pathTok = new StringTokenizer(prefs.getProperty("editor." + i + ".classpath"), File.pathSeparator);
					while (pathTok.hasMoreTokens())
						urls.add(new File(pathTok.nextToken()).toURL());
				}
			}
			//urls.add(new File(folder, "ContestApplet.jar").toURL());
			URL[] urlArray = new URL[urls.size()];
			urls.toArray(urlArray);
			classLoader = new URLClassLoader(urlArray, Thread.currentThread().getContextClassLoader());
		}
		catch (Exception ex)
		{
		}
		switch (languageid)
		{
			case CPPLanguage.ID:
				try
				{
					String classname = prefs.getProperty("kawigi.language." + ExtendedCPPLanguage.EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".override");
					return (ExtendedLanguage)ProxyLanguage.newProxy(classLoader.loadClass(classname).newInstance(), classLoader);
				}
				catch (Exception ex)
				{
					return new ExtendedCPPLanguage();
				}
			case CSharpLanguage.ID:
				try
				{
					String classname = prefs.getProperty("kawigi.language." + ExtendedCSharpLanguage.EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".override");
					return (ExtendedLanguage)ProxyLanguage.newProxy(classLoader.loadClass(classname).newInstance(), classLoader);
				}
				catch (Exception ex)
				{
					return new ExtendedCSharpLanguage();
				}
			case JavaLanguage.ID:
				try
				{
					String classname = prefs.getProperty("kawigi.language." + ExtendedJavaLanguage.EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".override");
					return (ExtendedLanguage)ProxyLanguage.newProxy(classLoader.loadClass(classname).newInstance(), classLoader);
				}
				catch (Exception ex)
				{
					return new ExtendedJavaLanguage();
				}
			//You know, this one isn't even in the documentation:
			case VBLanguage.ID:
				try
				{
					String classname = prefs.getProperty("kawigi.language." + ExtendedVBLanguage.EXTENDED_VB_LANGUAGE.getPropertyClass() + ".override");
					return (ExtendedLanguage)ProxyLanguage.newProxy(classLoader.loadClass(classname).newInstance(), classLoader);
				}
				catch (Exception ex)
				{
					return new ExtendedVBLanguage();
				}
			default:
				return new ExtendedJavaLanguage();
		}
	}
	
	/**
	 *	Returns an Extended Language using baselang for its basic functionality.
	 **/
	public static ExtendedLanguage getLanguage(Language baselang)
	{
		return getLanguage(baselang.getId());
	}
}