package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import javax.swing.text.*;
import java.util.*;
import java.io.File;
import kawigi.editor.*;
import kawigi.template.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

public class ExtendedCSharpLanguage extends LanguageContainer implements Templatable
{
	/**
	 *	A singleton instance of the extended C# language.
	 **/
	public static final ExtendedCSharpLanguage EXTENDED_CSHARP_LANGUAGE = new ExtendedCSharpLanguage();
	
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".filename") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".filename", "$PROBLEM$.cs");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".compiler") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".compiler", "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\csc.exe\" $PROBLEM$.cs");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".run") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".run", "\"$CWD$" + File.separator + "$PROBLEM$.exe\"");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".imports") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".imports", "System,System.Collections,System.Collections.Specialized,System.Text,System.Text.RegularExpressions");
		TemplateManager.register("C# Template", EXTENDED_CSHARP_LANGUAGE);
	}
	
	/**
	 *	Constructs a new extended C# language based on <code>lang</code>.
	 *	
	 *	If <code>lang</code> is not an instance of CSharpLanguage, this class may not function normally.
	 **/
	public ExtendedCSharpLanguage(Language lang)
	{
		super(lang);
	}
	
	/**
	 *	Constructs a new extended C# instance from TC's singleton C# language instance.
	 **/
	public ExtendedCSharpLanguage()
	{
		super(CSharpLanguage.CSHARP_LANGUAGE);
	}
	
	/**
	 *	Returns at a class and method declaration, with a main method that has testing code.
	 **/
	public Skeleton getSkeleton(ProblemComponent comp)
	{
		caret = 0;
		return new Skeleton(getTemplateCode(comp, this), caret);
	}
	
	/**
	 *	Used to set the caret location in the code template.
	 **/
	protected int caret;	
	
	/**
	 *	Returns the testing code for the problem statement's default testing cases.
	 **/
	protected String generateTestingCode(ProblemComponent comp, Language lang)
	{
		String testcode = "\t#region Testing code generated by KawigiEdit\n";
		testcode += "\t[STAThread]\n";
		testcode += "\tpublic static void Main(string[] args)\n\t{\n";
		TestCase[] cases = comp.getTestCases();
		//skeleton += "\t\tlong time;\n";
		String returnType = comp.getReturnType().getDescriptor(lang);
		testcode += "\t\t" + returnType + " answer, desiredAnswer;\n";
		testcode += "\t\tbool errors = false, same;\n";
		boolean stringType = returnType.toLowerCase().startsWith("string");
		testcode += "\t\tDateTime time;\n";
		for (int i=0; i<cases.length; i++)
		{
			testcode += "\t\ttime = DateTime.Now;\n";
			testcode += "\t\tanswer = new " + comp.getClassName() + "()." + comp.getMethodName() + "(" + toTest(cases[i], comp.getParamTypes()) + ");\n";;
			testcode += "\t\tConsole.WriteLine(\"Time: \" + (DateTime.Now-time).TotalSeconds + \" seconds\");\n";
			testcode += "\t\tdesiredAnswer = " + translateObject(returnType, cases[i].getOutput()) + ";\n";
			testcode += "\t\tConsole.WriteLine(\"Your answer:\");\n";
			//If writing code that writes code isn't confusing enough, maybe writing code that writes code that writes code-like constructs is
			if (returnType.endsWith("[]"))
			{
				testcode += "\t\tif (answer.Length > 0)\n";
				testcode += "\t\t{\n";
				testcode += "\t\t\tConsole.Write(\"\\t{ " + (stringType ? "\\\"\" + answer[0] + \"\\\"\"" : "\" + answer[0]") + ");\n";
				testcode += "\t\t\tfor (int i=1; i<answer.Length; i++)\n";
				testcode += "\t\t\t\tConsole.Write(\"," + (stringType ? "\\n\\t  \\\"" : " ") + "\" + answer[i]" + (stringType ? " + \"\\\"\"": "") + ");\n";
				testcode += "\t\t\tConsole.WriteLine(\" }\");\n";
				testcode += "\t\t}\n";
				testcode += "\t\telse\n";
				testcode += "\t\t\tConsole.WriteLine(\"\\t{ }\");\n";
				testcode += "\t\tConsole.WriteLine(\"Desired answer:\");\n";
				testcode += "\t\tif (desiredAnswer.Length > 0)\n";
				testcode += "\t\t{\n";
				testcode += "\t\t\tConsole.Write(\"\\t{ " + (stringType ? "\\\"\" + desiredAnswer[0] + \"\\\"\"" : "\" + desiredAnswer[0]") + ");\n";
				testcode += "\t\t\tfor (int i=1; i<desiredAnswer.Length; i++)\n";
				testcode += "\t\t\t\tConsole.Write(\"," + (stringType ? "\\n\\t  \\\"" : " ") + "\" + desiredAnswer[i]" + (stringType ? " + \"\\\"\"": "") + ");\n";
				testcode += "\t\t\tConsole.WriteLine(\" }\");\n";
				testcode += "\t\t}\n";
				testcode += "\t\telse\n";
				testcode += "\t\t\tConsole.WriteLine(\"\\t{ }\");\n";
				testcode += "\t\tsame = (desiredAnswer.Length == answer.Length);\n";
				testcode += "\t\tfor (int i=0; i<answer.Length && same; i++)\n";
				testcode += "\t\t\tif (answer[i] != desiredAnswer[i])\n";
				testcode += "\t\t\t\tsame = false;\n";
				testcode += "\t\tif (!same)\n";
			}
			else
			{
				testcode += "\t\tConsole.WriteLine(\"\\t" + (stringType ? "\\\"" : "") + "\" + answer" + (stringType ? " + \"\\\"\"" : "") + ");\n";
				testcode += "\t\tConsole.WriteLine(\"Desired answer:\");\n";
				testcode += "\t\tConsole.WriteLine(\"\\t" + (stringType ? "\\\"" : "") + "\" + desiredAnswer" + (stringType ? " + \"\\\"\"" : "") + ");\n";
				testcode += "\t\tif (answer != desiredAnswer)\n";
			}
			testcode += "\t\t{\n";
			testcode += "\t\t\terrors = true;\n";
			testcode += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\");\n";
			testcode += "\t\t}\n";
			testcode += "\t\telse\n";
			testcode += "\t\t\tConsole.WriteLine(\"Match :-)\");\n";

			testcode += "\t\tConsole.WriteLine();\n";
		}
		testcode += "\t\t\n\t\tif (errors)\n";
		testcode += "\t\t\tConsole.WriteLine(\"Some of the test cases had errors :-(\");\n";
		testcode += "\t\telse\n";
		testcode += "\t\t\tConsole.WriteLine(\"You're a stud (at least on the test data)! :-D \");\n";
		testcode += "\t}\n";
		testcode += "\t#endregion\n";
		return testcode;
	}
	
	/**
	 *	The templatable method for the C# template
	 **/
	public String getTemplateCode(ProblemComponent comp, Language lang)
	{
		String skeleton = "";
		LocalPreferences prefs = LocalPreferences.getInstance();
		String[] imports = prefs.getProperty("kawigi.language." + getPropertyClass() + ".imports").split(",");
		for (int i=0; i<imports.length; i++)
			skeleton += "using " + imports[i] + ";\n";
		skeleton += "\npublic class " + comp.getClassName() + "\n{\n";
		skeleton += "\tpublic " + comp.getReturnType(getId()) + " " + comp.getMethodName() + "(";
		skeleton += makeParamList(comp.getParamTypes(), comp.getParamNames());
		skeleton += ")\n\t{\n";
		skeleton += "\t\t\n";
		caret = skeleton.length()-1;
		skeleton += "\t}\n\t\n";
		skeleton += generateTestingCode(comp, lang);
		skeleton += "}\n";
		skeleton += "\n//Powered by [KawigiEdit]\n";
		return skeleton;
	}
	
	/**
	 *	Quick utility function to provide the code that should return the answer.
	 **/
	protected String toTest(TestCase test, DataType[] types)
	{
		String ret = "";
		String[] input = test.getInput();
		ret += translateObject(types[0].getDescriptor(this), input[0]);
		for (int i=1; i<input.length; i++)
			ret += ", " + translateObject(types[i].getDescriptor(this), input[i]);
		ret = ret.replaceAll("\\n", "");
		return ret;
	}
	
	/**
	 *	Quck utility function to convert a value to code that creates that value in Java.
	 **/
	protected static String translateObject(String type, String value)
	{
		if (type.endsWith("[]"))
		{
			if (type.startsWith("long"))
			{
				String ret = "new " + type + "{ ";
				StringTokenizer tok = new StringTokenizer(value, " {},");
				while (tok.hasMoreTokens())
				{
					ret += tok.nextToken() + "L";
					if (tok.hasMoreTokens())
						ret += ", ";
				}
				ret += " }";
				return ret;
			}
			else if (type.startsWith("double") || type.startsWith("float"))
			{
				String ret = "new " + type + "{ ";
				StringTokenizer tok = new StringTokenizer(value, " {},");
				while (tok.hasMoreTokens())
				{
					ret += tok.nextToken() + type.toUpperCase().charAt(0);
					if (tok.hasMoreTokens())
						ret += ", ";
				}
				ret += " }";
				return ret;
			}
			else
				return "new " + type + value;
		}
		else if (type.equals("long"))
			return value + "L";
		else if (type.equals("float") || type.equals("double"))
		{
			if (value.indexOf('.') < 0)
				value += ".0";
			return value + type.toUpperCase().charAt(0);
		}
		else
			return value;
	}
	
	/**
	 *	Returns a string in the format <type> <name>, <type> <name>, etc.
	 **/
	protected String makeParamList(DataType[] types, String[] names)
	{
		String ret = "";
		for (int i=0; i<types.length; i++)
		{
			if (i > 0)
				ret += ", ";
			ret += types[i].getDescriptor(this) + " " + names[i];
		}
		return ret;
	}
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.
	 **/
	public String getCompileCommand(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".compiler";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\csc\" $PROBLEM$.cs");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".run";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"$CWD$\\$PROBLEM$.exe\"");
		command = command.replaceAll("\\$CWD\\$", cwd.getPath().replaceAll("\\\\", "\\\\\\\\"));
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".filename";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "$PROBLEM$.cs");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the class of the C# implementation of a View
	 **/
	public Class getViewClass()
	{
		return CSharpView.class;
	}
	
	/**
	 *	Overrides the property class in LanguageContainer so that it only has alphanumeric characters.
	 **/
	public String getPropertyClass()
	{
		return "csharp";
	}
	
	/**
	 *	Returns the KTT template representing how this class is templated.
	 **/
	public Template getTemplate()
	{
		return new Template(getClass().getName(), "getTemplateCode", new String[]{"com.topcoder.shared.problem.ProblemComponent comp", "com.topcoder.shared.language.Language lang"});
	}
	
	/**
	 *	Returns a library of tags that may come in useful for writing templates extending this class.
	 **/
	public TagLibrary getNativeTagLibrary()
	{
		TagLibrary taglib = new TagLibrary();
		taglib.addMethod("class-name", new String[0], new String[]{"code += comp.getClassName();"});
		taglib.addMethod("method-name", new String[0], new String[]{"code += comp.getMethodName();"});
		taglib.addMethod("return-type", new String[0], new String[]{"code += comp.getReturnType().getDescriptor(lang);"});
		taglib.addMethod("param-list", new String[0], new String[]{"code += makeParamList(comp.getParamTypes(), comp.getParamNames());"});
		taglib.addMethod("testing-code", new String[0], new String[]{"code += generateTestingCode(comp, lang);"});
		taglib.addMethod("set-caret", new String[0], new String[]{"caret = code.length();"});
		return taglib;
	}
	
	/**
	 *	Returns the text of a default template.
	 **/
	public String getDefaultTemplateCode()
	{
		return	"<%!include " + getClass().getName() + " %>\n"
			+	"using System;\n"
			+	"using System.Collections;\n"
			+	"using System.Collections.Specialized;\n"
			+	"using System.Text;\n"
			+	"using System.Text.RegularExpressions;\n\n"
			+	"public class <%:class-name%>\n"
			+	"{\n"
			+	"\tpublic <%:return-type%> <%:method-name%>(<%:param-list%>)\n"
			+	"\t{\n"
			+	"\t\t<%:set-caret%>\n"
			+	"\t}\n\n"
			+	"<%:testing-code%>\n"
			+	"}\n"
			+	"//Powered by [KawigiEdit]\n";
	}
}
