package kawigi.editor;
import javax.swing.text.*;
import java.awt.*;
import java.util.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

public class TemplateView extends JavaView
{
	private static Color tagColor;
	
	static
	{
		initColors();
	}
	
	public static void initColors()
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.editor.TemplateTagColor") == null)
			prefs.setColor("kawigi.editor.TemplateTagColor", tagColor = new Color(64, 192, 255));
		else
			tagColor = prefs.getColor("kawigi.editor.TemplateTagColor");
	}
	
	/**
	 *	Creates a new TemplateView and forwards down the element.
	 **/
	public TemplateView(Element e)
	{
		super(e);
	}
	
	/**
	 *	Overridden from PlainView - this method gets called to render every element
	 *	of unselected text.
	 **/
	protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException
	{
		String s = getDocument().getText(p0, p1 - p0);
		String before = getDocument().getText(0, p0);
		boolean inComment = false;
		boolean inAction = false;
		for (int i=0; i<before.length(); i++)
		{
			if (inAction && inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '*')
				inComment = false;
			else if (inAction && !inComment && before.charAt(i) == '*' && i > 0 && before.charAt(i-1) == '/')
				inComment = true;
			else if (!inAction && before.charAt(i) == '%' && i > 0 && before.charAt(i-1) == '<')
				inAction = true;
			else if (inAction && !inComment && before.charAt(i) == '>' && i > 0 && before.charAt(i-1) == '%')
				inAction = false;
			else if (inAction && !inComment && before.charAt(i) == '\"')
				for (i = i+1; i<before.length() && before.charAt(i) != '\"' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (inAction && !inComment && before.charAt(i) == '\'')
				for (i = i+1; i<before.length() && before.charAt(i) != '\'' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (inAction && !inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '/')
				for (i = i+1; i<before.length() && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
		}
		return drawTabbedText(s, x, y, g, p0, false, inComment, inAction);
	}
	
	/**
	 *	Overridden from PlainView - this method gets called to render every element
	 *	of selected text, so that I could change how it's displayed if I want.
	 **/
	protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException
	{
		String s = getDocument().getText(p0, p1 - p0);
		String before = getDocument().getText(0, p0);
		boolean inComment = false;
		boolean inAction = false;
		for (int i=0; i<before.length(); i++)
		{
			if (inAction && inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '*')
				inComment = false;
			else if (inAction && !inComment && before.charAt(i) == '*' && i > 0 && before.charAt(i-1) == '/')
				inComment = true;
			else if (!inAction && before.charAt(i) == '%' && i > 0 && before.charAt(i-1) == '<')
				inAction = true;
			else if (inAction && !inComment && before.charAt(i) == '>' && i > 0 && before.charAt(i-1) == '%')
				inAction = false;
			else if (inAction && !inComment && before.charAt(i) == '\"')
				for (i = i+1; i<before.length() && before.charAt(i) != '\"' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (inAction && !inComment && before.charAt(i) == '\'')
				for (i = i+1; i<before.length() && before.charAt(i) != '\'' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (inAction && !inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '/')
				for (i = i+1; i<before.length() && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
		}
		return drawTabbedText(s, x, y, g, p0, true, inComment, inAction);
	}
	
	/**
	 *	Renders the text segment onto the given Graphics context.
	 *	
	 *	Originally, this looked a lot like javax.swing.text.Utilities.drawTabbedText
	 *	with a little bit of tokenizing, but now it's pretty much modified to my own
	 *	style.  Unfortunately, at some point in time, my indentation got all weird
	 *	(probably as a result of me using tabs and the original implementation mixing
	 *	spaces and tabs), so there may be some weird-looking parts left in the code.
	 *	
	 *	This is the magic of my syntax hilighting.
	 **/
	protected int drawTabbedText(String s, int x, int y, Graphics g, int startOffset, boolean selected, boolean inComment, boolean inAction)
	{
		if (selected)
			g.setColor(((JTextComponent)getContainer()).getSelectedTextColor());
		FontMetrics metrics = g.getFontMetrics();
		int flushIndex = 0;
		for (int i=0; i<s.length(); i++)
		{
			if (!inAction && s.charAt(i) == '<' && i < s.length()-1 && s.charAt(i+1) == '%')
			{
				if (!selected)
					g.setColor(getContainer().getForeground());
				g.drawString(s.substring(flushIndex, i), x, y);
				x += metrics.stringWidth(s.substring(flushIndex, i));
				flushIndex = i;
				if (!selected)
					g.setColor(tagColor);
				g.drawString(s.substring(i, i+2), x, y);
				x += metrics.stringWidth(s.substring(i, i+2));
				flushIndex = i+2;
				i +=2;
				inAction = true;
			}
			if (inAction)
			{
				if (i < s.length() && (s.charAt(i) == '!' || s.charAt(i) == ':' || s.charAt(i) == '='))
				{
					for (; i<s.length() && (i == 0 || s.charAt(i) != '>' || s.charAt(i-1) != '%'); i++)
						if (s.charAt(i) == '\t')
						{
							if (i > flushIndex)
							{
								if (!selected)
									g.setColor(tagColor);
								g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
							}
							flushIndex = i+1;
							x = (int)nextTabStop((float)x, startOffset+i);
						}
					if (!selected)
						g.setColor(tagColor);
					g.drawString(s.substring(flushIndex, Math.min(s.length(), i+1)), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, Math.min(s.length(), i+1)));
					flushIndex = Math.min(s.length(), i+1);
					inAction = false;
				}
				else
				{
					for (; i < s.length() && (i > s.length()-2 || s.charAt(i) != '%' || s.charAt(i+1) != '>'); i++)
					{
						//multiline comment state:
						if (s.charAt(i) == '/' && i < s.length()-1 && s.charAt(i+1) == '*')
							inComment = true;
						//parsing strings:
						if (!inComment && s.charAt(i) == '\"')
						{
							if (flushIndex < i)
							{
								if (!selected)
									if (inComment)
										g.setColor(commentColor);
									else
										g.setColor(getColor(s.substring(flushIndex, i)));
								g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
								flushIndex = i;
							}
							i++;
							for (; i<s.length() && s.charAt(i) != '\"' && s.charAt(i) != '\n' && s.charAt(i) != '\r'; i++)
							{
								if (s.charAt(i) == '\t')
								{
									if (i > flushIndex)
									{
										if (!selected)
											g.setColor(stringColor);
										g.drawString(s.substring(flushIndex, i), x, y);
										x += metrics.stringWidth(s.substring(flushIndex, i));
									}
									flushIndex = i + 1;
									x = (int)nextTabStop((float)x, startOffset+i);
								}
								if (s.charAt(i) == '\\')
									i++;
							}
							if (!selected)
								if (inComment)
									g.setColor(commentColor);
								else
						    		g.setColor(stringColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
							if (i < s.length() && s.charAt(i) == '\"')
							{
								g.drawString(s.substring(i, i+1), x, y);
								x += metrics.charWidth(s.charAt(i));
							}
							flushIndex = i+1;
						}
						//treating chars like strings:
						else if (!inComment && s.charAt(i) == '\'')
						{
							if (flushIndex < i)
							{
								if (!selected)
									if (inComment)
										g.setColor(commentColor);
									else
										g.setColor(getColor(s.substring(flushIndex, i)));
								g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
								flushIndex = i;
					    	}
							i++;
							for (; i<s.length() && s.charAt(i) != '\'' && s.charAt(i) != '\n' && s.charAt(i) != '\r'; i++)
							{
								if (s.charAt(i) == '\t')
								{
									if (i > flushIndex)
									{
										if (!selected)
											g.setColor(stringColor);
										g.drawString(s.substring(flushIndex, i), x, y);
										x += metrics.stringWidth(s.substring(flushIndex, i));
									}
									flushIndex = i + 1;
									x = (int)nextTabStop((float)x, startOffset+i);
								}
								if (s.charAt(i) == '\\')
									i++;
							}
							if (!selected)
								if (inComment)
									g.setColor(commentColor);
								else
									g.setColor(stringColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
							if (i < s.length() && s.charAt(i) == '\'')
							{
								g.drawString(s.substring(i, i+1), x, y);
								x += metrics.charWidth(s.charAt(i));
							}
					    	flushIndex = i+1;
						}
						//Parsing single-line comments:
						else if (!inComment && s.charAt(i) == '/' && i < s.length()-1 && s.charAt(i+1) == '/')
						{
							if (flushIndex < i)
				    		{
								if (!selected)
									if (inComment)
										g.setColor(commentColor);
									else
										g.setColor(getColor(s.substring(flushIndex, i)));
								g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
							 	flushIndex = i;
					    	}
							for (; i<s.length() && s.charAt(i) != '\n' && s.charAt(i) != '\r'; i++)
							{
								if (s.charAt(i) == '\t')
								{
									if (i > flushIndex)
									{
										if (!selected)
					    					g.setColor(commentColor);
										g.drawString(s.substring(flushIndex, i), x, y);
										x += metrics.stringWidth(s.substring(flushIndex, i));
									}
									flushIndex = i + 1;
									x = (int)nextTabStop((float)x, startOffset+i);
								}
							}
							if (!selected)
								g.setColor(commentColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
				    		flushIndex = i+1;
						}
						//Tab case, I do my own tab expansion:
						else if (s.charAt(i) == '\t')
						{
							if (i > flushIndex)
							{
								if (!selected)
					    			g.setColor(getColor(s.substring(flushIndex, i)));
								g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
							}
							flushIndex = i + 1;
							x = (int) nextTabStop((float) x, startOffset+i);
						}
						//newline case:
						else if ((s.charAt(i) == '\n') || (s.charAt(i) == '\r'))
						{
							if (i > flushIndex)
							{
								if (!selected)
									if (inComment)
										g.setColor(commentColor);
									else
						    			g.setColor(getColor(s.substring(flushIndex, i)));
								g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
							}
							flushIndex = i + 1;
						}
						//valid token characters:
						else if (Character.isLetterOrDigit(s.charAt(i)) || s.charAt(i) == '_')
						{
						}
					    else
					    {
					    	//If the buffer isn't empty, flush it out as a token
					    	if (flushIndex < i)
							{
								if (!selected)
									if (inComment)
										g.setColor(commentColor);
									else
										g.setColor(getColor(s.substring(flushIndex, i)));
						    	g.drawString(s.substring(flushIndex, i), x, y);
								x += metrics.stringWidth(s.substring(flushIndex, i));
								flushIndex = i;
					    	}
							//draw the current character.
							if (!selected)
								if (inComment)
									g.setColor(commentColor);
								else
					    			g.setColor(getColor(s.substring(i, i+1)));
							g.drawString(s.substring(i, i+1), x, y);
							flushIndex = i+1;
							x += metrics.charWidth(s.charAt(i));
						}
						if (i < s.length() && s.charAt(i) == '/' && i > 0 && s.charAt(i-1) == '*')
							inComment = false;
					}
				}
				if (flushIndex < i)
				{
					if (!selected)
						if (inComment)
							g.setColor(commentColor);
						else
							g.setColor(getColor(s.substring(flushIndex, i)));
					g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
					flushIndex = i;
				}
				if (i < s.length()-1 && s.charAt(i) == '%' && s.charAt(i+1) == '>')
				{
					if (!selected)
						g.setColor(tagColor);
					g.drawString(s.substring(i, i+2), x, y);
					x += metrics.stringWidth(s.substring(i, i+2));
					flushIndex = i+2;
					i++;
					inAction = false;
				}
			}
			else
			{
				if (s.charAt(i) == '\t')
				{
					if (i > flushIndex)
					{
						if (!selected)
				   			g.setColor(getContainer().getForeground());
						g.drawString(s.substring(flushIndex, i), x, y);
						x += metrics.stringWidth(s.substring(flushIndex, i));
					}
					flushIndex = i + 1;
					x = (int) nextTabStop((float) x, startOffset+i);
				}
				else if (s.charAt(i) == '\n' || s.charAt(i) == '\r')
				{
					if (i > flushIndex)
					{
						if (!selected)
				   			g.setColor(getContainer().getForeground());
						g.drawString(s.substring(flushIndex, i), x, y);
						x += metrics.stringWidth(s.substring(flushIndex, i));
					}
					flushIndex = i+1;
				}
			}
		}
		//flush the buffer to the screen, if it has any content:
		if (flushIndex < s.length())
		{
			if (inAction && !selected)
				if (inComment)
					g.setColor(commentColor);
				else
					g.setColor(getColor(s.substring(flushIndex, s.length())));
			else if (!selected)
				g.setColor(getContainer().getForeground());
			g.drawString(s.substring(flushIndex, s.length()), x, y);
			x += metrics.stringWidth(s.substring(flushIndex, s.length()));
		}
		return x;
	}
	
	/**
	 *	Returns an <code>ArrayList</code> of Interval objects representing code block intervals
	 *	in the document.
	 *	
	 *	This one just matches template tags.
	 **/
	public ArrayList getIntervals()
	{
		ArrayList ret = new ArrayList();
		try
		{
			parseIndex = 0;
			lineIndex = 1;
			if (getDocument().getText(0, getDocument().getLength()).startsWith("\n"))
				lineIndex++;
			findIntervals(ret, getDocument().getText(0, getDocument().getLength()), new String[]{"<%", "%>"}, false);
		}
		catch (BadLocationException ex)
		{
		}
		return ret;
	}
}