package kawigi.editor;
import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.util.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

/**
 *	Ok, this is me just glorifying myself a little bit.
 **/
public class GenericView extends PlainView
{
	private static int tabstop;
	protected static Object highlightKey1, highlightKey2;
	private int hindex1, hindex2;
	private static Color matchParensColor;
	private static boolean matchParens;
	
	static
	{
		resetTabStop();
	}
	
	/**
	 *	Checks the property kawigi.editor.tabstop and sets the tabstop used in GenericView and derivatives to its value.
	 *	
	 *	It sets the property and the tabstop to 4 if the property isn't set.
	 **/
	public static void resetTabStop()
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.editor.tabstop") != null)
			tabstop = prefs.getFontSize("kawigi.editor.tabstop");
		else
			prefs.setProperty("kawigi.editor.tabstop", Integer.toString(tabstop = 4));
		if (prefs.getProperty("kawigi.editor.matchparens") == null)
			prefs.setTrue("kawigi.editor.matchparens", matchParens = true);
		else
			matchParens = prefs.isTrue("kawigi.editor.matchparens");
		if (prefs.getProperty("kawigi.editor.matchparenscolor") == null)
			prefs.setColor("kawigi.editor.matchparenscolor", matchParensColor = new Color(64, 64, 128));
		else
			matchParensColor = prefs.getColor("kawigi.editor.matchparenscolor");
	}
	
	/**
	 *	Just forwards that Element on down.
	 **/
	public GenericView(Element e)
	{
		super(e);
	}
	
	/**
	 *	A little hack to put a "TopCoder-ish" logo and a copycat logo for KawigiEdit in the background of the text pane.
	 *	
	 *	I know, it just makes me seem like I need attention or something, but I tried to at least make it look nice.
	 **/
	public void paint(Graphics g, Shape a)
	{
		Rectangle bounds = a.getBounds();
		Color c1 = getContainer().getForeground();
		Color c2 = getContainer().getBackground();
		int gray1 = (c1.getRed() + c1.getGreen() + c1.getBlue())/3;
		int gray2 = (c2.getRed() + c2.getGreen() + c2.getBlue())/3;
		Color c3 = new Color((gray2+gray2+gray1)/3, (gray2+gray2+gray1)/3, (gray2+gray2+gray1)/3);
		g.setColor(c3);
		g.setFont(new Font("Monospaced", Font.BOLD, 36));
		g.drawString("[Top     ]", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[TopCoder]")/2, g.getFontMetrics().getHeight());
		g.drawString("[Kawigi    ]", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[KawigiEdit]")/2, (int)bounds.getHeight() + (int)bounds.getY() - g.getFontMetrics().getDescent());
		//It's lines of code that looks like this that occasionally give me problems.  Hopefully this one won't.
		g.drawString("Thank you for using", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("Thank you for using")/2, (int)bounds.getHeight() + (int)bounds.getY() - g.getFontMetrics().getDescent()-g.getFontMetrics().getHeight());
		g.setColor(new Color(c3.getRed(), 0, 0));
		g.drawString("    Coder ", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[TopCoder]")/2, g.getFontMetrics().getHeight());
		g.drawString("       Edit ", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[KawigiEdit]")/2, (int)bounds.getHeight() + (int)bounds.getY() - g.getFontMetrics().getDescent());
		JTextComponent host = (JTextComponent)getContainer();
		g.setFont(host.getFont());
		
		if (matchParens)
		{
			ArrayList intervals = getIntervals();
			Interval use = null;
			int caret = host.getCaretPosition();
			for (int i=0; i<intervals.size(); i++)
			{
				Interval in = (Interval)intervals.get(i);
				if (caret >= in.getStartIndex() && caret <= in.getEndIndex() && (use == null || in.getEndIndex() - in.getStartIndex() < use.getEndIndex() - use.getStartIndex()))
					use = in;
			}
			try
			{
				if (use != null && (caret == use.getStartIndex() || caret == use.getEndIndex() || caret == use.getStartIndex()+1 || caret == use.getEndIndex()-1))
				{
					if (highlightKey1 == null)
					{
						highlightKey1 = ((JTextComponent)getContainer()).getHighlighter().addHighlight(use.getStartIndex(), use.getStartIndex()+use.getStartToken().length(), new DefaultHighlighter.DefaultHighlightPainter(matchParensColor));
						highlightKey2 = ((JTextComponent)getContainer()).getHighlighter().addHighlight(use.getEndIndex()-use.getEndToken().length(), use.getEndIndex(), new DefaultHighlighter.DefaultHighlightPainter(matchParensColor));
					}
					else if (hindex1 != use.getStartIndex() || hindex2 != use.getEndIndex())
					{
						hindex1 = use.getStartIndex();
						hindex2 = use.getEndIndex();
						host.getHighlighter().changeHighlight(highlightKey1, hindex1, hindex1+use.getStartToken().length());
						host.getHighlighter().changeHighlight(highlightKey2, hindex2-use.getEndToken().length(), hindex2);
					}
				}
				else if (highlightKey1 != null && hindex1 != 0 || hindex2 != 0)
				{
					hindex1 = 0;
					hindex2 = 0;
					host.getHighlighter().changeHighlight(highlightKey1, 0, 0);
					host.getHighlighter().changeHighlight(highlightKey2, 0, 0);
				}
			}
			catch (BadLocationException ex)
			{
			}
		}
		super.paint(g, a);
	}
	
	/**
	 *	Programmers don't like 8-space tabstops.
	 *	
	 *	At least I don't, so I set the default to 4.  At Ryan's request, this is now configurable.
	 **/
	protected int getTabSize()
	{
		return tabstop;
    }
    
	/**
	 *	Returns an <code>ArrayList</code> of Interval objects representing code block intervals
	 *	in the document.
	 *	
	 *	This default implementation matches curly braces, square brackets and parentheses.
	 **/
	public ArrayList getIntervals()
	{
		ArrayList ret = new ArrayList();
		try
		{
			parseIndex = 0;
			lineIndex = 1;
			findIntervals(ret, getDocument().getText(0, getDocument().getLength()), new String[]{"{", "}"}, true);
			parseIndex = 0;
			lineIndex = 1;
			findIntervals(ret, getDocument().getText(0, getDocument().getLength()), new String[]{"(", ")"}, false);
			parseIndex = 0;
			lineIndex = 1;
			findIntervals(ret, getDocument().getText(0, getDocument().getLength()), new String[]{"[", "]"}, false);
		}
		catch (BadLocationException ex)
		{
		}
		return ret;
	}
	
	/**
	 *	Set parseIndex to 0 and lineIndex to 1 before calling findIntervals.
	 **/
	protected int parseIndex, lineIndex;
	
	/**
	 *	Helper function to help with <code>getIntervals</code>.
	 *	
	 *	Puts the intervals into the list in an in-order traversal of curly braces.
	 **/
	protected void findIntervals(ArrayList list, String text, String[] startEnd, boolean block)
	{
		int startline = lineIndex;
		int startIndex = parseIndex;
		if (parseIndex == 0 && text.length() > 0 && text.charAt(0) == '\n')
			lineIndex ++;
		parseIndex++;
		while (parseIndex < text.length())
		{
			if (text.charAt(parseIndex) == '\n')
				lineIndex ++;
			else if (text.substring(parseIndex).startsWith(startEnd[0]))
			{
				findIntervals(list, text, startEnd, block);
			}
			else if (text.substring(parseIndex).startsWith(startEnd[1]))
			{
				Interval in = findName(text, startIndex, startline, lineIndex, parseIndex, startEnd, block);
				if (in != null)
					list.add(in);
				return;
			}
			else if (text.charAt(parseIndex) == '\"')
			{
				parseIndex++;
				while (parseIndex < text.length() && text.charAt(parseIndex) != '\"' && text.charAt(parseIndex) != '\n' && text.charAt(parseIndex) != '\r')
				{
					if (text.charAt(parseIndex) == '\\')
						parseIndex++;
					parseIndex++;
				}
			}
			else if (text.charAt(parseIndex) == '/' && parseIndex+1 < text.length())
			{
				if (text.charAt(parseIndex+1) == '/')
				{
					while (parseIndex < text.length() && text.charAt(parseIndex) != '\n' && text.charAt(parseIndex) != '\r')
						parseIndex++;
					parseIndex--;
				}
				else if (text.charAt(parseIndex+1) == '*')
				{
					parseIndex+=2;
					//check for a new line but not the end of the comment on this character:
					if (text.charAt(parseIndex) == '\n')
						lineIndex++;
					parseIndex++;
					while (parseIndex < text.length() && !(text.charAt(parseIndex) == '/' && text.charAt(parseIndex-1) == '*'))
					{
						if (text.charAt(parseIndex) == '\n')
							lineIndex++;
						parseIndex++;
					}
					parseIndex--;
				}
			}
			parseIndex++;
		}
	}
	
	/**
	 *	Searches for a String identifier for a block in the text before the block
	 *	
	 *	May or may not be particularly useful in many situations.  This is called by findIntervals.
	 **/
	protected Interval findName(String text, int index, int startline, int endline, int endindex, String[] startEnd, boolean block)
	{
		if (index == 0 &! text.startsWith(startEnd[0]))
			return null;
		String ret = "";
		index --;
		int i;
		for (i=Math.min(index, text.length()-1); i>= 0; i--)
		{
			if (ret.length() > 0 && text.charAt(i) == '\n')
			{
				break;
			}
			else if (text.charAt(i) == '\n')
				startline --;
			if (!Character.isWhitespace(text.charAt(i)) || ret.length() > 0)
			{
				ret = text.charAt(i) + ret;
			}
		}
		return new Interval(startline, endline, index+1, endindex+startEnd[1].length(), ret.trim(), startEnd[0], startEnd[1], block);
	}
	
	/**
	 *	NOTHING BUT A HACK (and a weird, dirty one at that).
	 *	
	 *	This is a "fix" to the problem where after undoing exceptions occurred causing the cursor to not update its
	 *	position after edits (which leads to a really strange editing experience after that point, as you might
	 *	imagine).  In the case that it was reaching when this bug occurred, It seems I can force the parent of this
	 *	class to do something of a double take by spoofing its parent element and calling an update method.  Any
	 *	cleaner hack seemed impossible due to the use of private methods and even package-level access classes.
	 *	
	 *	This appears to be a blatant bug in Swing.  I think a real fix to this would be in
	 *	AbstractDocument$BranchElement.getEndOffset(), but the necessary check here might not really solve the problem,
	 *	just get it out of my way in this case.  In this odd case, nchildren is zero, and getEndOffset() tries
	 *	to access the element at index -1.  Reproducing the bug is about as simple as creating a JTextPane that uses
	 *	a PlainView to render, install a pretty standard UndoManager on it, write some arbitrary text into it, and
	 *	then select and paste in some other big text or something, then undo (with whatever mechanism you have for
	 *	that, for me it's a keystroke).
	 **/
	protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f)
	{
		//most of this first code is from the beginning of the method it overrides.
		Component host = getContainer();
		updateMetrics();
		Element elem = getElement();
		DocumentEvent.ElementChange ec = changes.getChange(elem);
		Element[] added = (ec != null) ? ec.getChildrenAdded() : null;
		Element[] removed = (ec != null) ? ec.getChildrenRemoved() : null;
		if (((added != null) && (added.length > 0)) || 
		((removed != null) && (removed.length > 0))) {
			//this part is my silly hack.
			View root = getParent();
			setParent(new FakeRootView(added != null && added.length > 0 ? added[0] : removed[0]));
			updateMetrics();
			setParent(root);
			updateMetrics();
			//end of silly hack.
			preferenceChanged(null, true, true);
			host.repaint();
		}
		super.updateDamage(changes, a, f);
	}
    
    /**
     *	Part 2 of my super-dirty hack.
     *	
     *	This is one of the most retarded classes I've ever written.
     **/
    class FakeRootView extends PlainView
    {
		public FakeRootView(Element e)
		{
			super(e);
		}
		
    	public Container getContainer()
    	{
    		return new NoWrapJTextPane();
    	}
    }
}
