package kawigi.config;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import kawigi.template.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

/**
 *	Manages editing cells in the JComboBox that has the names of all of the tags in a TagLibrary
 **/
public class TagNameEditor implements ComboBoxEditor
{
	/**
	 *	The text field for editing the text.
	 **/
	private JTextField textField;
	
	/**
	 *	The selected object.
	 *	
	 *	This is not automatically synched with the text field or anything, in fact, it's really only
	 *	here so I can do something useful in setItem and getItem.
	 **/
	private Object method;
	
	/**
	 *	Creates a new TagNameEditor and sets up the text field according to the user's settings.
	 **/
	public TagNameEditor()
	{
		textField = new JTextField();
		LocalPreferences prefs = LocalPreferences.getInstance();
		textField.setBackground(prefs.getColor("kawigi.editor.background"));
		textField.setForeground(prefs.getColor("kawigi.editor.foreground"));
		textField.setCaretColor(prefs.getColor("kawigi.editor.foreground"));
		textField.setSelectedTextColor(prefs.getColor("kawigi.editor.SelectedTextColor"));
		textField.setSelectionColor(prefs.getColor("kawigi.editor.SelectionColor"));
	}
	
	/**
	 * Returns a JTextField for editing names of stuff.
	 **/
	public Component getEditorComponent()
	{
		return textField;
	}
	
	/**
	 * Sets the MethodInfo object that should be edited.
	 **/
	public void setItem(Object item)
	{
		method = item;
		if (item != null)
			textField.setText(item.toString());
		else
			textField.setText("");
	}

	/**
	 * Returns the selected item.
	 **/
	public Object getItem()
	{
		return method;
	}
	
	/**
	 * Returns the text in the editor.
	 **/
	public String getText()
	{
		return textField.getText();
	}

	/**
	 * Selects the text being edited.
	 **/
	public void selectAll()
	{
		//easy enough!
		textField.selectAll();
	}
	
	/**
  	 * Add an ActionListener.
  	 *
  	 * An action event is generated when the edited item changes
  	 **/
	public void addActionListener(ActionListener l)
	{
		textField.addActionListener(l);
	}

	/**
	 * Remove an ActionListener.
	 **/
	public void removeActionListener(ActionListener l)
	{
		textField.removeActionListener(l);
	}
}