package kawigi.config;
import javax.swing.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.awt.*;

/**
 *	Generic panel to display testing options for a specific language.
 **/
public class LanguageConfigPanel extends JPanel
{
	private JTextField compileField, filenameField, runField, importsField;
	private LocalPreferences prefs;
	private String prefix;
	
	/**
	 *	Creates a LanguageConfigPanel that gets its starting values from prefs, (and
	 *	also calls back to prefs).  It will look at prefix as a starting point to
	 *	get properties, where prefix will be "kawigi.language.<language property class>".
	 **/
	public LanguageConfigPanel(LocalPreferences prefs, String prefix)
	{
		this.prefs = prefs;
		this.prefix = prefix;
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		JPanel labelPanel = new JPanel(new GridLayout(4, 1));
		JPanel stuffPanel = new JPanel(new GridLayout(4, 1));
		
		JLabel filenameLabel = new JLabel("File Name:");
		filenameLabel.setForeground(Color.white);
		labelPanel.add(filenameLabel);
		filenameField = new JTextField(prefs.getProperty(prefix + ".filename"), 20);
		stuffPanel.add(filenameField);
		
		JLabel compileLabel = new JLabel("Compile Command:");
		compileLabel.setForeground(Color.white);
		labelPanel.add(compileLabel);
		compileField = new JTextField(prefs.getProperty(prefix + ".compiler"), 20);
		stuffPanel.add(compileField);
		
		JLabel runLabel = new JLabel("Run Command:");
		runLabel.setForeground(Color.white);
		labelPanel.add(runLabel);
		runField = new JTextField(prefs.getProperty(prefix + ".run"), 20);
		stuffPanel.add(runField);
		
		JLabel importsLabel = new JLabel("Libraries:");
		importsLabel.setForeground(Color.white);
		labelPanel.add(importsLabel);
		importsField = new JTextField(prefs.getProperty(prefix + ".imports"), 20);
		stuffPanel.add(importsField);
		
		add(labelPanel);
		add(stuffPanel);
	}
	
	/**
	 *	Calls back to the local preferences with the updated values from the user.
	 **/
	public void doUpdates()
	{
		prefs.setProperty(prefix + ".filename", filenameField.getText());
		prefs.setProperty(prefix + ".compiler", compileField.getText());
		prefs.setProperty(prefix + ".run", runField.getText());
		prefs.setProperty(prefix + ".imports", importsField.getText());
	}
}