package kawigi.config;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import kawigi.editor.*;
import kawigi.timer.*;

/**
 *	This is the dialog that gets popped up when you click on "Configure" in the
 *	editor plugin settings in TopCoder.
 **/
public class ConfigPanel extends JDialog implements ActionListener
{
	private JButton browseButton, cancelButton, okButton;
	private JTextField fileField;
	private JFileChooser filechooser;
	private JCheckBox stduiBox, matchParensBox, showTimerBox;
	private LocalPreferences prefs;
	private ColorWidget testingBackground, testingForeground, classColor, commentColor, directiveColor;
	private ColorWidget keywordColor, operatorColor, stringColor, typeColor, editorBackground;
	private ColorWidget editorForeground, matchColor, selectionColor, selectedTextColor, tagColor;
	private ColorWidget timerForeground, timerBackground, timerUnlit;
	private FontPanel testingFontPanel, editorFontPanel;
	private LanguageConfigPanel javaPanel, cppPanel, csharpPanel, vbPanel;
	private JSpinner tabSpinner, timeoutSpinner, delaySpinner;
	
	/**
	 *	Creates the GUI components to be displayed.
	 **/
	public ConfigPanel()
	{
		super((JFrame)null, "KawigiEdit Configuration", true);
		prefs = LocalPreferences.getInstance();
		filechooser = new JFileChooser();
		filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		JTabbedPane tabs = new JTabbedPane();
		
		/*	Properties:
			kawigi.localpath
			kawigi.timeout
			kawigi.stdui
			kawigi.testing.background
			kawigi.testing.font
			kawigi.testing.font.size
			kawigi.testing.foreground
		*/
		JPanel generalTestingPanel = new JPanel();
		generalTestingPanel.setLayout(new BoxLayout(generalTestingPanel, BoxLayout.Y_AXIS));
		
		JPanel generalPanel = new JPanel();
		generalPanel.setLayout(new BoxLayout(generalPanel, BoxLayout.Y_AXIS));
		JPanel filePanel = new JPanel();
		filePanel.setLayout(new BoxLayout(filePanel, BoxLayout.X_AXIS));
		fileField = new JTextField(prefs.getProperty("kawigi.localpath"), 15);
		browseButton = new JButton("Browse");
		browseButton.addActionListener(this);
		filePanel.add(makeLabel("Local Directory:"));
		filePanel.add(fileField);
		filePanel.add(browseButton);
		generalPanel.add(filePanel);
		stduiBox = new JCheckBox("Use more standard UI", prefs.isTrue("kawigi.stdui"));
		stduiBox.setForeground(Color.white);
		stduiBox.setBackground(Color.darkGray);
		generalPanel.add(stduiBox);
		timeoutSpinner = new JSpinner(new SpinnerNumberModel(prefs.getFontSize("kawigi.timeout"), 1, 100, 1));
		JPanel timeoutPanel = new JPanel();
		timeoutPanel.setLayout(new BoxLayout(timeoutPanel, BoxLayout.X_AXIS));
		timeoutPanel.add(makeLabel("Local Process Timeout:"));
		timeoutPanel.add(timeoutSpinner);
		generalPanel.add(timeoutPanel);
		generalPanel.add(makeLabel("Note that the timeout is for"));
		generalPanel.add(makeLabel("all test cases combined!"));
		generalPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		generalTestingPanel.add(generalPanel);
		
		JPanel testingPanel = new JPanel();
		testingPanel.setLayout(new BoxLayout(testingPanel, BoxLayout.Y_AXIS));
		testingFontPanel = new FontPanel(new Font(prefs.getProperty("kawigi.testing.font"), Font.PLAIN, prefs.getFontSize("kawigi.testing.font.size")));
		testingPanel.add(testingFontPanel);
		testingBackground = new ColorWidget(prefs.getColor("kawigi.testing.background"));
		testingForeground = new ColorWidget(prefs.getColor("kawigi.testing.foreground"));
		JPanel testingBgColorPanel = new JPanel();
		testingBgColorPanel.add(makeLabel("Background: "));
		testingBgColorPanel.add(testingBackground);
		JPanel testingFgColorPanel = new JPanel();
		testingFgColorPanel.add(makeLabel("Foreground: "));
		testingFgColorPanel.add(testingForeground);
		testingPanel.add(testingBgColorPanel);
		testingPanel.add(testingFgColorPanel);
		testingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Testing", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		generalTestingPanel.add(testingPanel);
		
		JPanel timerPanel = new JPanel();
		timerPanel.setLayout(new BoxLayout(timerPanel, BoxLayout.Y_AXIS));
		JPanel timerLabelPanel = new JPanel(new GridLayout(4, 1));
		JPanel timerDataPanel = new JPanel(new GridLayout(4, 1));
		timerLabelPanel.add(makeLabel("Problem Timer Delay (milliseconds):"));
		timerLabelPanel.add(makeLabel("Timer LED Color:"));
		timerLabelPanel.add(makeLabel("Timer Background Color:"));
		timerLabelPanel.add(makeLabel("Unlit LED Color:"));
		delaySpinner = new JSpinner(new SpinnerNumberModel(prefs.getFontSize("kawigi.timer.delay"), 50, 60000, 10));
		timerDataPanel.add(delaySpinner);
		timerDataPanel.add(timerForeground = new ColorWidget(prefs.getColor("kawigi.timer.foreground")));
		timerDataPanel.add(timerBackground = new ColorWidget(prefs.getColor("kawigi.timer.background")));
		timerDataPanel.add(timerUnlit = new ColorWidget(prefs.getColor("kawigi.timer.unlit")));
		JPanel mostTimerPanel = new JPanel();
		mostTimerPanel.setLayout(new BoxLayout(mostTimerPanel, BoxLayout.X_AXIS));
		mostTimerPanel.add(timerLabelPanel);
		mostTimerPanel.add(timerDataPanel);
		timerPanel.add(mostTimerPanel);
		showTimerBox = new JCheckBox("Show Problem Timer", prefs.isTrue("kawigi.timer.show"));
		showTimerBox.setForeground(Color.white);
		showTimerBox.setBackground(Color.darkGray);
		timerPanel.add(showTimerBox);
		timerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Problem Timer", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		generalTestingPanel.add(timerPanel);
		
		JPanel tempGeneralPanel = new JPanel();
		tempGeneralPanel.add(generalTestingPanel);
		tabs.add(tempGeneralPanel, "General/Testing");
		
		/*	Propeties:
			kawigi.editor.ClassColor
			kawigi.editor.CommentColor
			kawigi.editor.DirectiveColor
			kawigi.editor.KeywordColor
			kawigi.editor.OperatorColor
			kawigi.editor.StringColor
			kawigi.editor.TypeColor
			kawigi.editor.background
			kawigi.editor.tabstop
			kawigi.editor.font
			kawigi.editor.font.size
			kawigi.editor.foreground
		*/
		JPanel editorPanel = new JPanel();
		editorPanel.setLayout(new BoxLayout(editorPanel, BoxLayout.Y_AXIS));
		JPanel labelPanel = new JPanel(new GridLayout(15, 1));
		JPanel colorsPanel = new JPanel(new GridLayout(15, 1));
		labelPanel.add(makeLabel("Default Color:"));
		labelPanel.add(makeLabel("Background Color:"));
		labelPanel.add(makeLabel("Selection Color:"));
		labelPanel.add(makeLabel("Selected Text Color:"));
		labelPanel.add(makeLabel("Keyword Color:"));
		labelPanel.add(makeLabel("Type Color:"));
		labelPanel.add(makeLabel("Operator Color:"));
		labelPanel.add(makeLabel("String Color:"));
		labelPanel.add(makeLabel("Comment Color:"));
		labelPanel.add(makeLabel("Directive Color:"));
		labelPanel.add(makeLabel("Class Color:"));
		labelPanel.add(makeLabel("Template Tag Color:"));
		labelPanel.add(makeLabel("Matching Color:"));
		labelPanel.add(makeLabel(""));
		labelPanel.add(makeLabel("Tab size:"));
		colorsPanel.add(editorForeground = new ColorWidget(prefs.getColor("kawigi.editor.foreground")));
		colorsPanel.add(editorBackground = new ColorWidget(prefs.getColor("kawigi.editor.background")));
		colorsPanel.add(selectionColor = new ColorWidget(prefs.getColor("kawigi.editor.SelectionColor")));
		colorsPanel.add(selectedTextColor = new ColorWidget(prefs.getColor("kawigi.editor.SelectedTextColor")));
		colorsPanel.add(keywordColor = new ColorWidget(prefs.getColor("kawigi.editor.KeywordColor")));
		colorsPanel.add(typeColor = new ColorWidget(prefs.getColor("kawigi.editor.TypeColor")));
		colorsPanel.add(operatorColor = new ColorWidget(prefs.getColor("kawigi.editor.OperatorColor")));
		colorsPanel.add(stringColor = new ColorWidget(prefs.getColor("kawigi.editor.StringColor")));
		colorsPanel.add(commentColor = new ColorWidget(prefs.getColor("kawigi.editor.CommentColor")));
		colorsPanel.add(directiveColor = new ColorWidget(prefs.getColor("kawigi.editor.DirectiveColor")));
		colorsPanel.add(classColor = new ColorWidget(prefs.getColor("kawigi.editor.ClassColor")));
		colorsPanel.add(tagColor = new ColorWidget(prefs.getColor("kawigi.editor.TemplateTagColor")));
		colorsPanel.add(matchColor = new ColorWidget(prefs.getColor("kawigi.editor.matchparenscolor")));
		matchParensBox = new JCheckBox("Match Parentheses", prefs.isTrue("kawigi.editor.matchparens"));
		matchParensBox.setForeground(Color.white);
		matchParensBox.setBackground(Color.darkGray);
		colorsPanel.add(matchParensBox);
		colorsPanel.add(tabSpinner = new JSpinner(new SpinnerNumberModel(prefs.getFontSize("kawigi.editor.tabstop"), 1, 16, 1)));
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		p.add(labelPanel);
		p.add(colorsPanel);
		editorPanel.add(p);
		editorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Editor Settings", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		editorFontPanel = new FontPanel(new Font(prefs.getProperty("kawigi.editor.font"), Font.PLAIN, prefs.getFontSize("kawigi.editor.font.size")));
		editorPanel.add(editorFontPanel);
		
		JPanel editorTempPanel = new JPanel();
		editorTempPanel.add(editorPanel);
		tabs.add(editorTempPanel, "Editor");
		
		/*	Properties:
			kawigi.language.cpp.compile
			kawigi.language.cpp.filename
			kawigi.language.cpp.run
			kawigi.language.csharp.compiler
			kawigi.language.csharp.filename
			kawigi.language.csharp.run
			kawigi.language.java.compiler
			kawigi.language.java.filename
			kawigi.language.java.run
			kawigi.language.vb.compiler
			kawigi.language.vb.filename
			kawigi.language.vb.run
		*/
		JPanel languagePanel = new JPanel(new GridLayout(4, 1));
		javaPanel = new LanguageConfigPanel(prefs, "kawigi.language.java");
		cppPanel = new LanguageConfigPanel(prefs, "kawigi.language.cpp");
		csharpPanel = new LanguageConfigPanel(prefs, "kawigi.language.csharp");
		vbPanel = new LanguageConfigPanel(prefs, "kawigi.language.vb");
		javaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Java", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		cppPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "C++", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		csharpPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "C#", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		vbPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Visual Basic", TitledBorder.LEFT, TitledBorder.TOP, new Font("Serif", Font.BOLD, 12), Color.white));
		languagePanel.add(javaPanel);
		languagePanel.add(cppPanel);
		languagePanel.add(csharpPanel);
		languagePanel.add(vbPanel);
		
		JPanel tempLangPanel = new JPanel();
		tempLangPanel.add(languagePanel);
		tabs.add(tempLangPanel, "Languages");
		
		tabs.add(new TemplateEditor(), "Template Editor");
		tabs.add(new TagLibEditor(), "Tag Library Editor");
		
		JPanel okCancelPanel = new JPanel();
		okButton = new JButton("OK");
		okButton.addActionListener(this);
		cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(this);
		okCancelPanel.add(okButton);
		okCancelPanel.add(cancelButton);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(okCancelPanel, BorderLayout.SOUTH);
		getContentPane().add(tabs, BorderLayout.CENTER);
	}
	
	/**
	 *	Little utility JLabel factory that makes sure my JLabels display with white
	 *	text.
	 **/
	private JLabel makeLabel(String text)
	{
		JLabel label = new JLabel(text);
		label.setForeground(Color.white);
		return label;
	}
	
	/**
	 *	Event handler for my buttons.  Pops up a file open dialog if the browse button
	 *	is hit, disposes if cancel is hit, and saves and disposes if ok is hit.
	 **/
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == okButton)
		{
			prefs.setProperty("kawigi.localpath", fileField.getText());
			prefs.setTrue("kawigi.stdui", stduiBox.isSelected());
			prefs.setProperty("kawigi.timeout", timeoutSpinner.getValue().toString());
			prefs.setColor("kawigi.testing.background", testingBackground.getColor());
			prefs.setColor("kawigi.testing.foreground", testingForeground.getColor());
			prefs.setProperty("kawigi.testing.font", testingFontPanel.getSelectedFont().getName());
			prefs.setProperty("kawigi.testing.font.size", Integer.toString(testingFontPanel.getSelectedFont().getSize()));
			prefs.setColor("kawigi.editor.foreground", editorForeground.getColor());
			prefs.setColor("kawigi.editor.background", editorBackground.getColor());
			prefs.setColor("kawigi.editor.ClassColor", classColor.getColor());
			prefs.setColor("kawigi.editor.CommentColor", commentColor.getColor());
			prefs.setColor("kawigi.editor.DirectiveColor", directiveColor.getColor());
			prefs.setColor("kawigi.editor.OperatorColor", operatorColor.getColor());
			prefs.setColor("kawigi.editor.KeywordColor", keywordColor.getColor());
			prefs.setColor("kawigi.editor.StringColor", stringColor.getColor());
			prefs.setColor("kawigi.editor.TypeColor", typeColor.getColor());
			prefs.setColor("kawigi.editor.SelectionColor", selectionColor.getColor());
			prefs.setColor("kawigi.editor.SelectedTextColor", selectedTextColor.getColor());
			prefs.setColor("kawigi.editor.TemplateTagColor", tagColor.getColor());
			prefs.setColor("kawigi.editor.matchparenscolor", matchColor.getColor());
			prefs.setTrue("kawigi.editor.matchparens", matchParensBox.isSelected());
			prefs.setProperty("kawigi.editor.font", editorFontPanel.getSelectedFont().getName());
			prefs.setProperty("kawigi.editor.font.size", Integer.toString(editorFontPanel.getSelectedFont().getSize()));
			prefs.setProperty("kawigi.editor.tabstop", tabSpinner.getValue().toString());
			prefs.setProperty("kawigi.timer.delay", delaySpinner.getValue().toString());
			prefs.setTrue("kawigi.timer.show", showTimerBox.isSelected());
			prefs.setColor("kawigi.timer.foreground", timerForeground.getColor());
			prefs.setColor("kawigi.timer.background", timerBackground.getColor());
			prefs.setColor("kawigi.timer.unlit", timerUnlit.getColor());
			GenericView.resetTabStop();
			javaPanel.doUpdates();
			cppPanel.doUpdates();
			csharpPanel.doUpdates();
			vbPanel.doUpdates();
			CPPView.initColors();
			CSharpView.initColors();
			JavaView.initColors();
			VBView.initColors();
			TemplateView.initColors();
			ProblemTimer.resetPrefs();
			dispose();
		}
		else if (e.getSource() == cancelButton)
		{
			dispose();
		}
		else if (e.getSource() == browseButton)
		{
			if (filechooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
				fileField.setText(filechooser.getSelectedFile().getPath());
		}
	}
}
