package kawigi.challenge;
import javax.swing.*;
import java.awt.*;
import java.util.*;

public class TableCell extends JComponent
{
	private String text;
	private int width, height;
	
	public TableCell(String text)
	{
		this.text = text;
	}
	
	public String getText()
	{
		return text;
	}
	
	public void setText(String text)
	{
		this.text = text;
	}
	
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		g.setColor(Color.white);
		g.fillRect(0, 0, getWidth(), getHeight());
		g.setColor(Color.black);
		g.drawRect(0, 0, getWidth()-1, getHeight()-1);
		FontMetrics metrics = g.getFontMetrics();
		int twidth = metrics.stringWidth(text);
		int theight = metrics.getAscent() + metrics.getDescent();
		if (twidth > 500)
		{
			while (metrics.stringWidth(text + "...") > 500)
				text = text.substring(0, text.length()-1);
			text += "...";
			twidth = metrics.stringWidth(text);
		}
		g.drawString(text, 5, 5+metrics.getAscent());
		if (width != twidth || height != theight)
		{
			width = twidth;
			height = theight;
			revalidate();
		}
	}
	
	public Dimension getPreferredSize()
	{
		return new Dimension(width+10, height+10);
	}
}