package kawigi.challenge;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.util.regex.*;

public class HistoryLookup extends JPanel implements ActionListener, Runnable
{
	private JTabbedPane tabs;
	private JButton getButton;
	private JTextField handleField;
	private Vector problemInfo;
	private JList list;
	private JComboBox divisionBox;
	
	public HistoryLookup()
	{
		super(new BorderLayout());
		tabs = new JTabbedPane();
		add(tabs);
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new BoxLayout(bottomPanel, BoxLayout.X_AXIS));
		handleField = new JTextField(12);
		handleField.addActionListener(this);
		getButton = new JButton("Get Info");
		getButton.addActionListener(this);
		divisionBox = new JComboBox(new String[]{"Division 1", "Division 2"});
		JLabel handleLabel = new JLabel("Handle:");
		handleLabel.setForeground(Color.white);
		bottomPanel.add(handleLabel);
		bottomPanel.add(handleField);
		bottomPanel.add(divisionBox);
		bottomPanel.add(getButton);
		add(bottomPanel, BorderLayout.SOUTH);
		problemInfo = new Vector();
		list = new JList(problemInfo);
		tabs.add(new JScrollPane(list), "Problem History");
	}
	
	public static JFrame getFrame()
	{
		JFrame frame = new JFrame("Challenge Tools");
		frame.getContentPane().add(new HistoryLookup());
		frame.setSize(500, 600);
		return frame;
	}
	
	final static int CODER_INFO = 1, DIV_I_INFO = 2, DIV_II_INFO = 3, CHALLENGE_INFO = 4;
	public synchronized void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == getButton || e.getSource() == handleField)
		{
			new Thread(this).start();
		}
		else
		{
			Component c = (Component)e.getSource();
			while (! (c instanceof JScrollPane))
				c = c.getParent();
			tabs.remove(c);
		}
	}
	
	public void run()
	{
		StringTokenizer tok = new StringTokenizer(handleField.getText(), ", \r\n\t\f");
		while (tok.hasMoreTokens())
		{
			String handle = tok.nextToken();
			JPanel newPanel = new JPanel();
			newPanel.setLayout(new BoxLayout(newPanel, BoxLayout.Y_AXIS));
			int[] coderinfo = new int[6];
			int[][] div1info = new int[3][3], div2info = new int[3][3], challengeInfo = new int[3][2];
			int count = 1;
			try
			{
				XMLReader in = new XMLReader(new URL("http://www.topcoder.com/tc?module=SimpleSearch&ha=" + handle).openStream());
				Tag t;
				while ((t = in.nextTag()) != null)
				{
					if (t.isOpenTag() && t.getIdentifier().equalsIgnoreCase("table"))
					{
						TableViewer table = new TableViewer();
						int tabletype = 0;
						int index = 0;
						boolean skip = false;
						boolean using = false;
						while ((t = in.nextTag()) != null &! (t.isCloseTag() && t.getIdentifier().equalsIgnoreCase("table")))
						{
							if (t.isCloseTag() && t.getIdentifier().equalsIgnoreCase("tr"))
								table.endRow();
							else if (t.isOpenTag() && t.getIdentifier().equalsIgnoreCase("td"))
							{
								boolean found = false;
								while ((t = in.nextTag()) != null &! (t.isCloseTag() && t.getIdentifier().equalsIgnoreCase("td")))
								{
									if (t.isText() &! found &! skip)
									{
										found = true;
										String colspan = t.getAttributeValue("colspan");
										String rowspan = t.getAttributeValue("rowspan");
										String text = t.getText();
										text = text.replaceAll("&quot;", "\"");
										text = text.replaceAll("&lt;", "<");
										text = text.replaceAll("&gt;", ">");
										text = text.replaceAll("&nbsp;", " ");
										text = text.replaceAll("&amp;", "&");
										Matcher m = Pattern.compile("&#([0-9]+);").matcher(text);
										while (m.find())
										{
											String group = m.group(1);
											text = text.replaceAll("&#" + group + ";", new String(new char[]{(char)Integer.parseInt(group)}));
										}
										if (count == 12 && text.charAt(0) == '"')
										{
											table.addCell("Coder: " + handle, (rowspan == null ? 1 : Integer.parseInt(rowspan)), (colspan == null ? 1 : Integer.parseInt(colspan)));
											table.endRow();
											using = true;
											tabletype = CODER_INFO;
										}
										else if (text.indexOf("Division-I Submission Information") >= 0)
										{
											using = true;
											tabletype = DIV_I_INFO;
										}
										else if (text.indexOf("Division-II Submission Information") >= 0)
										{
											using = true;
											tabletype = DIV_II_INFO;
										}
										else if (text.indexOf("Challenge Information") >= 0)
										{
											using = true;
											tabletype = CHALLENGE_INFO;
										}
										if (text.indexOf("Design Statistics") == 2)
											skip = true;
										else
											table.addCell(text, (rowspan == null ? 1 : Integer.parseInt(rowspan)), (colspan == null ? 1 : Integer.parseInt(colspan)));
										if (tabletype != 0)
										{
											try
											{
												int num = Integer.parseInt(text.trim());
												switch (tabletype)
												{
													case CODER_INFO:
														if (index < coderinfo.length)
															coderinfo[index] = num;
														break;
													case DIV_I_INFO:
														if (index < div1info.length*div1info[0].length)
															div1info[index/3][index%3] = num;
														break;
													case DIV_II_INFO:
														if (index < div2info.length*div2info[0].length)
															div2info[index/3][index%3] = num;
														break;
													case CHALLENGE_INFO:
														if (index < challengeInfo.length*challengeInfo[0].length)
															challengeInfo[index/2][index%2] = num;
														break;
												}
												index++;
											}
											catch (NumberFormatException ex)
											{
											}
										}
									}
								}
							}
						}
						if (using)
						{
							newPanel.add(table);
							newPanel.add(new JLabel(" "));
						}
						count++;
					}
				}
				JButton removeButton = new JButton("Remove");
				removeButton.addActionListener(this);
				newPanel.add(removeButton);
				tabs.add(new JScrollPane(newPanel), handle);
				CoderHistory coder = new CoderHistory(handle, coderinfo, div1info, div2info, challengeInfo);
				for (int i=0; i<3; i++)
					problemInfo.add(coder.getProblemHistory(divisionBox.getSelectedIndex(), i));
				Collections.sort(problemInfo);
				list.setListData(problemInfo);
			}
			catch (IOException ex)
			{
				System.err.println(ex);
			}
		}
	}
	
	public static void main(String[] args)
	{
		JFrame frame = getFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.show();
	}
}