package kawigi.util;
import java.io.*;
import javax.swing.text.*;

/**
 *	A threaded output listener for a process output stream (either stdout or stderr)
 **/
public class ProcessOutput implements Runnable
{
	private Thread t;
	private InputStream out;
	private JTextComponent output;
	private boolean done;
	
	/**
	 *	Creates a new <code>ProcessOutput</code> that reads <code>out</code> into
	 *	<code>output</code>.
	 **/
	public ProcessOutput(InputStream out, JTextComponent output)
	{
		this.out = out;
		this.output = output;
	}
	
	/**
	 *	Starts the thread.
	 **/
	public synchronized void start()
	{
		t = new Thread(this);
		t.start();
	}
	
	/**
	 *	Reads characters from the stream until it runs out of them.
	 *	
	 *	Flushes every line so there's a sort of compromise between speed and being
	 *	able to see what's happened so far.
	 **/
	public synchronized void run()
	{
		if (Thread.currentThread() == t)
		{
			try
			{
				int c;
				String s = "";
				while ((c = out.read()) != -1)
				{
					s += (char)c;
					if (c == '\n')
					{
						output.setText(output.getText() + s);
						s = "";
					}
				}
				output.setText(output.getText() + s);
			}
			catch (IOException ex)
			{
				ex.printStackTrace();
				output.setText(output.getText() + "***IOException***\n");
				done = true;
			}
			done = true;
		}
	}
	
	/**
	 *	Returns true if this output stream has stopped producing output.
	 **/
	public boolean isDone()
	{
		return done;
	}
}
