package kawigi.tools.reflect;
import java.util.*;
import kawigi.tools.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.io.*;

public class JarReflectorPanel extends JPanel implements TreeModel
{
	private ReflectorTreeElement root;
	private Vector listeners;
	private JTree tree;
	
	public JarReflectorPanel(String filename)
	{
		setLayout(new GridLayout(1, 1));
		setPreferredSize(new Dimension(500, 400));
		listeners = new Vector();
		root = new JarRootNode(new File(filename));
		tree = new JTree(this);
		add(new JScrollPane(tree));
	}
	
	public Object getRoot()
	{
		return root;
	}
	
	public Object getChild(Object parent, int index)
	{
		return ((ReflectorTreeElement)parent).getChild(index);
	}
	
	public int getChildCount(Object parent)
	{
		return ((ReflectorTreeElement)parent).children();
	}
	
	public boolean isLeaf(Object node)
	{
		return getChildCount(node) == 0;
	}
	
	public void valueForPathChanged(TreePath path, Object newValue)
	{
		//huh?
	}
	
	public int getIndexOfChild(Object parent, Object child)
	{
		ReflectorTreeElement p = (ReflectorTreeElement)parent;
		for (int i=0; i<p.children(); i++)
			if (child == p.getChild(i))
				return i;
		return -1;
	}
	
	public void addTreeModelListener(TreeModelListener l)
	{
		listeners.add(l);
	}
	
	public void removeTreeModelListener(TreeModelListener l)
	{
		listeners.remove(l);
	}	
}
