package kawigi.snippet;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class Snippet extends JMenuItem implements Serializable, MenuElement, Comparable
{
	private String code, name;
	private Category parent;
	
	public Snippet(String code, String name)
	{
		super(name);
		this.code = code;
		this.name = name;
	}
	
	public void setCategory(Category cat)
	{
		parent = cat;
	}
	
	public String getName()
	{
		return name;
	}
	
	public String getCode()
	{
		return code;
	}
	
	public void changeName(String name)
	{
		this.name = name;
		setText(name);
	}
	
	public void changeCode(String code)
	{
		this.code = code;
	}
	
	public String toString()
	{
		return "/* Snippet: " + name + " */\n" + code;
	}
	
	public int compareTo(Object o)
	{
		if (o instanceof Category)
			return -1;
		String otherString = (o instanceof Snippet) ? ((Snippet)o).getName() : o.toString();
		return getName().compareTo(otherString);
	}
	
	public void delete()
	{
		parent.remove(this);
	}
}