package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import javax.swing.text.*;
import kawigi.editor.*;
import java.util.*;
import java.io.File;
import com.topcoder.client.contestApplet.common.LocalPreferences;

public class ExtendedCPPLanguage extends LanguageContainer
{
	/**
	 *	A singleton instance of the extended C++ language.
	 **/
	public final static ExtendedCPPLanguage EXTENDED_CPP_LANGUAGE = new ExtendedCPPLanguage();
	
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.language." + EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".filename") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".filename", "$PROBLEM$.cpp");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".compile") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".compile", "g++ $PROBLEM$.cpp");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".run") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CPP_LANGUAGE.getPropertyClass() + ".run", (File.separatorChar == '/' ? "$CWD$/a.out" : "\"$CWD\\a.exe\""));
	}
	
	/**
	 *	Creates a new instance of an extended C++ Language from the given TC language implementation.
	 *	
	 *	If <code>lang</code> is not an instance of CPPLanguage, this object may do weird things, but
	 *	then again, C++ coders tend to know when they want something to malfunction.
	 **/
	public ExtendedCPPLanguage(Language lang)
	{
		super(lang);
	}
	
	/**
	 *	Creates a new instance of the extended C++ language from TC's singleton C++ Language instance.
	 **/
	public ExtendedCPPLanguage()
	{
		super(CPPLanguage.CPP_LANGUAGE);
	}
	
	/**
	 *	Returns at a class and method declaration, with a main method that has testing code.
	 **/
	public String getSkeleton(ProblemComponent comp)
	{
		
		String skeleton = "#include <string>\n";
		skeleton += "#include <vector>\n";
		skeleton += "#include <list>\n";
		skeleton += "#include <map>\n";
		skeleton += "#include <set>\n";
		skeleton += "#include <deque>\n";
		skeleton += "#include <stack>\n";
		skeleton += "#include <bitset>\n";
		skeleton += "#include <algorithm>\n";
		skeleton += "#include <functional>\n";
		skeleton += "#include <numeric>\n";
		skeleton += "#include <utility>\n";
		skeleton += "#include <sstream>\n";
		skeleton += "#include <iostream>\n";
		skeleton += "#include <iomanip>\n";
		skeleton += "#include <stdio.h>\n";
		skeleton += "#include <cstdio>\n";
		skeleton += "#include <cmath>\n";
		skeleton += "#include <math.h>\n";
		skeleton += "#include <stdlib.h>\n\n";
		skeleton += "using namespace std;\n\n";
		skeleton += "class " + comp.getClassName() + " {\n";
		skeleton += "public:\n\t" + comp.getReturnType(getId()) + " " + comp.getMethodName() + "(";
		DataType[] paramTypes = comp.getParamTypes();
		skeleton += paramTypes[0].getDescriptor(this);
		for (int i=1; i<paramTypes.length; i++)
			skeleton += ", " + paramTypes[i].getDescriptor(this);
		skeleton += ");\n};\n\n";
		skeleton += comp.getReturnType(getId()) + " " + comp.getClassName() + "::" + comp.getMethodName() + "(";
		String[] paramNames = comp.getParamNames();
		skeleton += paramTypes[0].getDescriptor(this) + " " + paramNames[0];
		for (int i=1; i<paramNames.length; i++)
			skeleton += ", " + paramTypes[i].getDescriptor(this) + " " + paramNames[i];
		skeleton += ") {\n}\n\n";
		TestCase[] cases = comp.getTestCases();
		for (int i=0; i<cases.length; i++)
		{
			skeleton += "int test" + i + "() {\n";
			String[] input = cases[i].getInput();
			for (int j=0; j<input.length; j++)
				skeleton += makeParameter(input[j], paramTypes[j], j);
			skeleton += "\t" + comp.getClassName() + " * obj = new " + comp.getClassName() + "();\n";
			skeleton += "\t" + comp.getReturnType().getDescriptor(this) + " my_answer = obj->" + comp.getMethodName() + "(";
			skeleton += "p0";
			for (int j=1; j<input.length; j++)
			{
				skeleton += ", p" + j;
			}
			skeleton += ");\n";
			skeleton += "\tdelete obj;\n";
			skeleton += makeParameter(cases[i].getOutput(), comp.getReturnType(), input.length);
			if (comp.getReturnType().getDescriptor(this).startsWith("vector"))
			{
				skeleton += "\tcout <<\"Desired answer: \" <<endl;\n";
				skeleton += "\tcout <<\"\\t{ \";\n";
				skeleton += "\tif (p" + input.length + ".size() > 0) {\n";
				skeleton += "\t\tcout <<p" + input.length + "[0];\n";
				skeleton += "\t\tfor (int i=1; i<p" + input.length + ".size(); i++)\n";
				skeleton += "\t\t\tcout <<\", \" <<p" + input.length + "[i];\n";
				skeleton += "\t\tcout <<\" }\" <<endl;\n";
				skeleton += "\t}\n";
				skeleton += "\telse\n";
				skeleton += "\t\tcout <<\"}\" <<endl;\n";
				skeleton += "\tcout <<endl <<\"Your answer: \" <<endl;\n";
				skeleton += "\tcout <<\"\\t{ \";\n";
				skeleton += "\tbool same = (p" + input.length + ".size() == my_answer.size());\n";
				skeleton += "\tif (my_answer.size() > 0) {\n";
				skeleton += "\t\tcout <<my_answer[0];\n";
				skeleton += "\t\tif (p" + input.length + "[0] != my_answer[0])\n";
				skeleton += "\t\t\tsame = 0;\n";
				skeleton += "\t\tfor (int i=1; i<my_answer.size(); i++) {\n";
				skeleton += "\t\t\tcout <<\", \" <<my_answer[i];\n";
				skeleton += "\t\t\tif (p" + input.length + "[i] != my_answer[i])\n";
				skeleton += "\t\t\t\tsame = 0;\n";
				skeleton += "\t\t}\n";
				skeleton += "\t\tcout <<\" }\" <<endl;\n";
				skeleton += "\t}\n";
				skeleton += "\telse\n";
				skeleton += "\t\tcout <<\"}\" <<endl;\n";
				skeleton += "\tif (!same) {\n";
			}
			else
			{
				skeleton += "\tcout <<\"Desired answer: \" <<endl;\n";
				skeleton += "\tcout <<\"\\t\" << p" + input.length + " <<endl;\n";
				skeleton += "\tcout <<\"Your answer: \" <<endl;\n";
				skeleton += "\tcout <<\"\\t\" << my_answer <<endl;\n";
				skeleton += "\tif (p" + input.length + " != my_answer) {\n";
			}
			skeleton += "\t\tcout <<\"DOESN'T MATCH!!!!\" <<endl <<endl;\n";
			skeleton += "\t\treturn -1;\n";
			skeleton += "\t}\n";
			skeleton += "\telse {\n";
			skeleton += "\t\tcout <<\"Match :-)\" <<endl <<endl;\n";
			skeleton += "\t\treturn 0;	//I want to eventually turn this into a time of some kind.\n";
			skeleton += "\t}\n";
			skeleton += "}\n";
		}
		skeleton += "\n//Powered by [KawigiEdit]\n";
		return skeleton;
	}
	
	/**
	 *	declares an array of the same type as a vector.
	 **/
	private static String toArray(String type, String name)
	{
		String t = getType(type);
		return t + " " + name + "[]";
	}
	
	/**
	 *	Gets the underlying type contained in a vector declaration.
	 **/
	private static String getType(String vectortype)
	{
		return vectortype.substring(vectortype.indexOf('<') + 1, vectortype.lastIndexOf('>'));
	}
	
	/**
	 *	Declares a variable called p&lt;number&gt; from the type and value given.
	 **/
	private String makeParameter(String param, DataType type, int number)
	{
		if (type.getDescriptor(this).startsWith("vector"))
		{
			String decl = "\t" + toArray(type.getDescriptor(this), "t" + number) + " = " + param + ";\n";
			decl += "\t" + type.getDescriptor(this) + " p" + number + "(t" + number + ", t" + number + "+sizeof(t" + number + ")/sizeof(" + getType(type.getDescriptor(this)) + "));\n";
			return decl;
		}
		else
			return "\t" + type.getDescriptor(this) + " p" + number + " = " + (type.getDescriptor(this).equals("string") ? "\"" : "") + param + (type.getDescriptor(this).equals("string") ? "\"" : "") + ";\n";
	}
	
	/**
	 *	Returns the class of the C++ implementation of a View
	 **/
	public Class getViewClass()
	{
		return CPPView.class;
	}
	
	/**
	 *	Overrides the property class in LanguageContainer so that it only has alphanumeric characters.
	 **/
	public String getPropertyClass()
	{
		return "cpp";
	}
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.
	 **/
	public String getCompileCommand(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".compiler";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "g++ $PROBLEM$.cpp");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".run";
		String def;
		if (File.separatorChar == '/')
			def = "$CWD$/a.out";
		else
			def = "\"" + cwd + "\\a.exe\"";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = def);
		command = command.replaceAll("\\$CWD\\$", cwd.getPath());
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".filename";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "$PROBLEM$.cpp");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
}
