package kawigi.editor;
import javax.swing.text.*;
import java.awt.*;

/**
 *	Ok, this is me just glorifying myself a little bit.
 **/
public class GenericView extends PlainView
{
	/**
	 *	Just forwards that Element on down.
	 **/
	public GenericView(Element e)
	{
		super(e);
	}
	
	/**
	 *	A little hack to put a "TopCoder-ish" logo and a copycat logo for KawigiEdit in the background of the text pane.
	 *	
	 *	I know, it just makes me seem like I need attention or something, but I tried to at least make it look nice.
	 **/
	public void paint(Graphics g, Shape a)
	{
		Rectangle bounds = a.getBounds();
		Color c1 = getContainer().getForeground();
		Color c2 = getContainer().getBackground();
		int gray1 = (c1.getRed() + c1.getGreen() + c1.getBlue())/3;
		int gray2 = (c2.getRed() + c2.getGreen() + c2.getBlue())/3;
		Color c3 = new Color((gray2+gray2+gray1)/3, (gray2+gray2+gray1)/3, (gray2+gray2+gray1)/3);
		g.setColor(c3);
		g.setFont(new Font("Monospaced", Font.BOLD, 36));
		g.drawString("[Top     ]", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[TopCoder]")/2, g.getFontMetrics().getHeight());
		g.drawString("[Kawigi    ]", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[KawigiEdit]")/2, (int)bounds.getHeight() + (int)bounds.getY() - g.getFontMetrics().getDescent());
		g.drawString("Thank you for using", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("Thank you for using")/2, (int)bounds.getHeight() + (int)bounds.getY() - g.getFontMetrics().getDescent()-g.getFontMetrics().getHeight());
		g.setColor(new Color(c3.getRed(), 0, 0));
		g.drawString("    Coder ", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[TopCoder]")/2, g.getFontMetrics().getHeight());
		g.drawString("       Edit ", (int)bounds.getWidth()/2+(int)bounds.getX()-g.getFontMetrics().stringWidth("[KawigiEdit]")/2, (int)bounds.getHeight() + (int)bounds.getY() - g.getFontMetrics().getDescent());
		//The admins said I could probably put the logo on if I put the little "TM"
		//thing at the end.  The actual character looked stupid in this font, so I
		//decided to draw it myself.
		int tmx = g.getFontMetrics().stringWidth("[TopCoder]")/2 + (int)bounds.getX() + (int)bounds.getWidth()/2;
		int tmy = g.getFontMetrics().getAscent();
		g.setFont(g.getFont().deriveFont((float)g.getFont().getSize()/2));
		g.setColor(c3);
		g.drawString("TM", tmx, tmy);
		super.paint(g, a);
	}
	
	/**
	 *	Programmers like 4-space tabstops.
	 *	
	 *	At least I do, and it's my editor, so live with it.  I suppose that if I find
	 *	out that a lot of people disagree with me, I'll make it configurable.
	 **/
	protected int getTabSize()
	{
		return 4;
    }
}