package kawigi.config;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

/**
 *	This is the dialog that gets popped up when you click on "Configure" in the
 *	editor plugin settings in TopCoder.
 **/
public class ConfigPanel extends JDialog implements ActionListener
{
	private JButton browseButton, cancelButton, okButton;
	private JTextField fileField;
	private JFileChooser filechooser;
	private JCheckBox stduiBox;
	private LocalPreferences prefs;
	private ColorWidget testingBackground, testingForeground, classColor, commentColor, directiveColor, keywordColor, operatorColor, stringColor, typeColor, editorBackground, editorForeground;
	private FontPanel testingFontPanel, editorFontPanel;
	private LanguageConfigPanel javaPanel, cppPanel, csharpPanel, vbPanel;
	
	/**
	 *	Creates the GUI components to be displayed.
	 **/
	public ConfigPanel()
	{
		super((JFrame)null, "KawigiEdit Configuration", true);
		System.out.println(getBackground());
		prefs = LocalPreferences.getInstance();
		filechooser = new JFileChooser();
		filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		JTabbedPane tabs = new JTabbedPane();
		
		/*
			kawigi.localpath : testprograms
			kawigi.stdui : false
			kawigi.testing.background : -1
			kawigi.testing.font : Monospaced
			kawigi.testing.font.size : 12
			kawigi.testing.foreground : -16777216
		*/
		JPanel generalTestingPanel = new JPanel();
		generalTestingPanel.setLayout(new BoxLayout(generalTestingPanel, BoxLayout.Y_AXIS));
		
		JPanel generalPanel = new JPanel();
		generalPanel.setLayout(new BoxLayout(generalPanel, BoxLayout.Y_AXIS));
		JPanel filePanel = new JPanel();
		filePanel.setLayout(new BoxLayout(filePanel, BoxLayout.X_AXIS));
		fileField = new JTextField(prefs.getProperty("kawigi.localpath"));
		browseButton = new JButton("Browse");
		browseButton.addActionListener(this);
		filePanel.add(makeLabel("Local Directory:"));
		filePanel.add(fileField);
		filePanel.add(browseButton);
		generalPanel.add(filePanel);
		stduiBox = new JCheckBox("Use more standard UI (not yet implemented)", prefs.isTrue("kawigi.stdui"));
		stduiBox.setForeground(Color.white);
		stduiBox.setBackground(Color.darkGray);
		generalPanel.add(stduiBox);
		generalPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General"));
		generalTestingPanel.add(generalPanel);
		
		JPanel testingPanel = new JPanel();
		testingPanel.setLayout(new BoxLayout(testingPanel, BoxLayout.Y_AXIS));
		testingFontPanel = new FontPanel(new Font(prefs.getProperty("kawigi.testing.font"), Font.PLAIN, prefs.getFontSize("kawigi.testing.font.size")));
		testingPanel.add(testingFontPanel);
		testingBackground = new ColorWidget(prefs.getColor("kawigi.testing.background"));
		testingForeground = new ColorWidget(prefs.getColor("kawigi.testing.foreground"));
		JPanel testingBgColorPanel = new JPanel();
		testingBgColorPanel.add(makeLabel("Background: "));
		testingBgColorPanel.add(testingBackground);
		JPanel testingFgColorPanel = new JPanel();
		testingFgColorPanel.add(makeLabel("Foreground: "));
		testingFgColorPanel.add(testingForeground);
		testingPanel.add(testingBgColorPanel);
		testingPanel.add(testingFgColorPanel);
		testingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Testing"));
		generalTestingPanel.add(testingPanel);
		
		JPanel tempGeneralPanel = new JPanel();
		tempGeneralPanel.add(generalTestingPanel);
		tabs.add(tempGeneralPanel, "General/Testing");
		
		/*
			kawigi.editor.ClassColor : -4243521
			kawigi.editor.CommentColor : -8388737
			kawigi.editor.DirectiveColor : -32897
			kawigi.editor.KeywordColor : -4210944
			kawigi.editor.OperatorColor : -4243649
			kawigi.editor.StringColor : -32897
			kawigi.editor.TypeColor : -8421377
			kawigi.editor.background : -16777216
			kawigi.editor.font : Monospaced
			kawigi.editor.font.size : 12
			kawigi.editor.foreground : -1
		*/
		JPanel editorPanel = new JPanel();
		editorPanel.setLayout(new BoxLayout(editorPanel, BoxLayout.Y_AXIS));
		JPanel labelPanel = new JPanel(new GridLayout(9, 1));
		JPanel colorsPanel = new JPanel(new GridLayout(9, 1));
		labelPanel.add(makeLabel("Default Color:"));
		labelPanel.add(makeLabel("Background Color:"));
		labelPanel.add(makeLabel("Keyword Color:"));
		labelPanel.add(makeLabel("Type Color:"));
		labelPanel.add(makeLabel("Operator Color:"));
		labelPanel.add(makeLabel("String Color:"));
		labelPanel.add(makeLabel("Comment Color:"));
		labelPanel.add(makeLabel("Directive Color:"));
		labelPanel.add(makeLabel("Class Color:"));
		colorsPanel.add(editorForeground = new ColorWidget(prefs.getColor("kawigi.editor.foreground")));
		colorsPanel.add(editorBackground = new ColorWidget(prefs.getColor("kawigi.editor.background")));
		colorsPanel.add(keywordColor = new ColorWidget(prefs.getColor("kawigi.editor.KeywordColor")));
		colorsPanel.add(typeColor = new ColorWidget(prefs.getColor("kawigi.editor.TypeColor")));
		colorsPanel.add(operatorColor = new ColorWidget(prefs.getColor("kawigi.editor.OperatorColor")));
		colorsPanel.add(stringColor = new ColorWidget(prefs.getColor("kawigi.editor.StringColor")));
		colorsPanel.add(commentColor = new ColorWidget(prefs.getColor("kawigi.editor.CommentColor")));
		colorsPanel.add(directiveColor = new ColorWidget(prefs.getColor("kawigi.editor.DirectiveColor")));
		colorsPanel.add(classColor = new ColorWidget(prefs.getColor("kawigi.editor.ClassColor")));
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		p.add(labelPanel);
		p.add(colorsPanel);
		editorPanel.add(p);
		editorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Editor Settings"));
		editorFontPanel = new FontPanel(new Font(prefs.getProperty("kawigi.editor.font"), Font.PLAIN, prefs.getFontSize("kawigi.editor.font.size")));
		editorPanel.add(editorFontPanel);
		
		JPanel editorTempPanel = new JPanel();
		editorTempPanel.add(editorPanel);
		tabs.add(editorTempPanel, "Editor");
		
		/*
			kawigi.language.cpp.compile : g++ $PROBLEM$.cpp
			kawigi.language.cpp.filename : $PROBLEM$.cpp
			kawigi.language.cpp.run : "$CWD\a.exe"
			kawigi.language.csharp.compile : "C:\WINDOWS\Microsoft.NET\Framework\v1.1.4322\csc.exe" $PROBLEM$.cs
			kawigi.language.csharp.filename : $PROBLEM$.cs
			kawigi.language.csharp.run : "$CWD$\$PROBLEM$.exe"
			kawigi.language.java.compile : javac $PROBLEM$.java
			kawigi.language.java.filename : $PROBLEM$.java
			kawigi.language.java.run : java $PROBLEM$
			kawigi.language.vb.compile : "C:\WINDOWS\Microsoft.NET\Framework\v1.1.4322\vbc.exe" $PROBLEM$.vb
			kawigi.language.vb.filename : $PROBLEM$.vb
			kawigi.language.vb.run : "$CWD$\$PROBLEM$.exe"
		*/
		JPanel languagePanel = new JPanel(new GridLayout(4, 1));
		javaPanel = new LanguageConfigPanel(prefs, "kawigi.language.java");
		cppPanel = new LanguageConfigPanel(prefs, "kawigi.language.cpp");
		csharpPanel = new LanguageConfigPanel(prefs, "kawigi.language.csharp");
		vbPanel = new LanguageConfigPanel(prefs, "kawigi.language.vb");
		javaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Java"));
		cppPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "C++"));
		csharpPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "C#"));
		vbPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Visual Basic"));
		languagePanel.add(javaPanel);
		languagePanel.add(cppPanel);
		languagePanel.add(csharpPanel);
		languagePanel.add(vbPanel);
		
		JPanel tempLangPanel = new JPanel();
		tempLangPanel.add(languagePanel);
		tabs.add(tempLangPanel, "Languages");
		
		JPanel okCancelPanel = new JPanel();
		okButton = new JButton("OK");
		okButton.addActionListener(this);
		cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(this);
		okCancelPanel.add(okButton);
		okCancelPanel.add(cancelButton);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(okCancelPanel, BorderLayout.SOUTH);
		getContentPane().add(tabs, BorderLayout.CENTER);
	}
	
	/**
	 *	Little utility JLabel factory that makes sure my JLabels display with white
	 *	text.
	 **/
	private JLabel makeLabel(String text)
	{
		JLabel label = new JLabel(text);
		label.setForeground(Color.white);
		return label;
	}
	
	/**
	 *	Event handler for my buttons.  Pops up a file open dialog if the browse button
	 *	is hit, disposes if cancel is hit, and saves and disposes if ok is hit.
	 **/
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == okButton)
		{
			prefs.setProperty("kawigi.localpath", fileField.getText());
			prefs.setTrue("kawigi.stdui", stduiBox.isSelected());
			prefs.setColor("kawigi.testing.background", testingBackground.getColor());
			prefs.setColor("kawigi.testing.foreground", testingForeground.getColor());
			prefs.setProperty("kawigi.testing.font", testingFontPanel.getSelectedFont().getName());
			prefs.setProperty("kawigi.testing.font.size", Integer.toString(testingFontPanel.getSelectedFont().getSize()));
			prefs.setColor("kawigi.editor.foreground", editorForeground.getColor());
			prefs.setColor("kawigi.editor.background", editorBackground.getColor());
			prefs.setColor("kawigi.editor.ClassColor", classColor.getColor());
			prefs.setColor("kawigi.editor.CommentColor", commentColor.getColor());
			prefs.setColor("kawigi.editor.DirectiveColor", directiveColor.getColor());
			prefs.setColor("kawigi.editor.OperatorColor", operatorColor.getColor());
			prefs.setColor("kawigi.editor.KeywordColor", keywordColor.getColor());
			prefs.setColor("kawigi.editor.StringColor", stringColor.getColor());
			prefs.setColor("kawigi.editor.TypeColor", typeColor.getColor());
			prefs.setProperty("kawigi.editor.font", editorFontPanel.getSelectedFont().getName());
			prefs.setProperty("kawigi.editor.font.size", Integer.toString(editorFontPanel.getSelectedFont().getSize()));
			javaPanel.doUpdates();
			cppPanel.doUpdates();
			csharpPanel.doUpdates();
			vbPanel.doUpdates();
			dispose();
		}
		else if (e.getSource() == cancelButton)
		{
			dispose();
		}
		else if (e.getSource() == browseButton)
		{
			int accept = filechooser.showOpenDialog(this);
			if (accept == JFileChooser.APPROVE_OPTION)
				fileField.setText(filechooser.getSelectedFile().getPath());
		}
	}
}
