package kawigi.challenge;
import java.text.*;

public class ProblemHistory implements Comparable
{
	private double correctOdds, challengeOdds;
	private String name;
	private int level;
	private static NumberFormat fmt;
	
	static
	{
		fmt = NumberFormat.getPercentInstance();
		fmt.setMaximumFractionDigits(2);
	}
	
	public ProblemHistory(String codername, int level, double correctOdds, double challengeableOdds)
	{
			name = codername;
			this.correctOdds = correctOdds;
			challengeOdds = challengeableOdds;
			this.level = level;
	}
	
	public int compareTo(Object o)
	{
		ProblemHistory other = (ProblemHistory)o;
		if (correctOdds == other.correctOdds)
			if (challengeOdds == other.challengeOdds)
				return 0;
			else
				return (challengeOdds < other.challengeOdds) ? 1 : -1;
		else
			return (correctOdds < other.correctOdds) ? -1 : 1;
	}
	
	public String toString()
	{
		return name + " level " + level + " : " + fmt.format(challengeOdds) + " " + fmt.format(correctOdds);
	}
}