package kawigi.tools.reflect;
import java.util.*;
import java.util.jar.*;
import java.io.*;

public class JarRootNode implements ReflectorTreeElement
{
	private PackageNode node;
	private String jarname;
	
	public JarRootNode(File jarfile)
	{
		try
		{
			jarname = jarfile.getName();
			JarFile jar = new JarFile(jarfile);
			Enumeration entries = jar.entries();
			node = new PackageNode("");
			while (entries.hasMoreElements())
			{
				JarEntry entry = (JarEntry)entries.nextElement();
				if (!entry.isDirectory() && entry.getName().endsWith(".class") && entry.getName().indexOf('$') < 0)
					node.addClass(entry.getName());
			}
		}
		catch (IOException ex)
		{
			System.out.println("I/O Exception.  Is " + jarfile + " a java archive?");
		}
		catch (ClassNotFoundException ex)
		{
			System.out.println("Class not found - " + ex);
		}
	}
	
	public ReflectorTreeElement getChild(int index)
	{
		return node;
	}
	
	public int children()
	{
		return 1;
	}
	
	public String toString()
	{
		return jarname;
	}
}