package kawigi.language;
import com.topcoder.shared.language.*;

/**
 *	A quick way to get the right ExtendedLanguage object for your needs.
 **/
public class ExtendedLanguageFactory
{
	/**
	 *	Creates an Extended Language of the type given in the language id.
	 **/
	public static ExtendedLanguage getLanguage(int languageid)
	{
		switch (languageid)
		{
			case CPPLanguage.ID:
				return new ExtendedCPPLanguage();
			case CSharpLanguage.ID:
				return new ExtendedCSharpLanguage();
			case JavaLanguage.ID:
				return new ExtendedJavaLanguage();
			//You know, this one isn't even in the documentation:
			case VBLanguage.ID:
				return new ExtendedVBLanguage();
			default:
				return new ExtendedJavaLanguage();
		}
	}
	
	/**
	 *	Returns an Extended Language using baselang for its basic functionality.
	 **/
	public static ExtendedLanguage getLanguage(Language baselang)
	{
		switch (baselang.getId())
		{
			case CPPLanguage.ID:
				return new ExtendedCPPLanguage(baselang);
			case CSharpLanguage.ID:
				return new ExtendedCSharpLanguage(baselang);
			case JavaLanguage.ID:
				return new ExtendedJavaLanguage(baselang);
			case VBLanguage.ID:
				return new ExtendedVBLanguage(baselang);
			default:
				return new ExtendedJavaLanguage(baselang);
		}
	}
}