package kawigi.tools.reflect;
import java.lang.reflect.*;
import java.util.*;

public class ClassNode implements ReflectorTreeElement
{
	private Class cls;
	private Vector children;
	
	public ClassNode(Class cls)
	{
		this.cls = cls;
		children = new Vector();
		try
		{
			Class[] innerClasses = cls.getDeclaredClasses();
			for (int i=0; i<innerClasses.length; i++)
				children.add(new ClassNode(innerClasses[i]));
			Field[] fields = cls.getFields();
			for (int i=0; i<fields.length; i++)
				children.add(new FieldNode(fields[i]));
			Constructor[] constructors = cls.getConstructors();
			for (int i=0; i<constructors.length; i++)
				children.add(new ConstructorNode(constructors[i]));
			Method[] methods = cls.getMethods();
			for (int i=0; i<methods.length; i++)
				if (methods[i].getDeclaringClass().equals(cls))
					children.add(new MethodNode(methods[i]));
		}
		catch (Throwable t)
		{
			children.add(new ErrorNode(t.getMessage()));
		}
	}
	
	public ReflectorTreeElement getChild(int index)
	{
		return (ReflectorTreeElement)children.elementAt(index);
	}
	
	public int children()
	{
		return children.size();
	}
	
	public String toString()
	{
		String ret = Modifier.toString(cls.getModifiers() & (~Modifier.INTERFACE) & (cls.isInterface() ? ~Modifier.ABSTRACT : -1)) + " " + (cls.isInterface() ? " interface " : " class ") + cls.getName();
		Class parent = cls.getSuperclass();
		if (parent != null && !parent.getName().equals("java.lang.Object"))
		{
			ret += " extends " + parent.getName();
		}
		Class[] interfaces = cls.getInterfaces();
		if (interfaces.length > 0)
		{
			ret += " implements " + interfaces[0].getName();
			for (int i=1; i<interfaces.length; i++)
				ret += ", " + interfaces[i].getName();
		}
		return ret;
	}	
}
