package kawigi.editor;

/**
 *	Represents a block of code that is logically delimited (like by parentheses, curly braces, or other
 *	matched constructs).
 **/
public class Interval
{
	private int startline, endline, startindex, endindex;
	private String name;
	
	/**
	 *	Constructs a new Interval with the given fields.
	 **/
	public Interval(int start, int end, int startind, int endind, String name)
	{
		startline = start;
		endline = end;
		startindex = startind;
		endindex = endind;
		this.name = name;
	}
	
	/**
	 *	Returns the "name" of this block.
	 *	
	 *	The name usually comes from somewhere right before the start of the block.  It won't always have
	 *	any meaning, but it will end in with the start and end delimiters that define the interval.
	 **/
	public String getName()
	{
		return name;
	}
	
	/**
	 *	Returns the line number that the block starts on.
	 *
	 *  This includes the "title" of the block, if it's on a previous line.
	 **/
	public int getStartLine()
	{
		return startline;
	}
	
	/**
	 *	Returns the line number that the block ends on.
	 **/
	public int getEndLine()
	{
		return endline;
	}
	
	/**
	 *	Returns the literal index in the string that the block starts on.
	 *	
	 *	This doesn't include the title of the block.
	 **/
	public int getStartIndex()
	{
		return startindex;
	}
	
	/**
	 *	Returns the literal index in the string of code that the block ends on.
	 **/
	public int getEndIndex()
	{
		return endindex;
	}
}