package kawigi.editor;
import javax.swing.text.*;
import java.awt.*;
import java.util.*;
import com.topcoder.client.contestApplet.common.LocalPreferences;

public class CSharpView extends GenericView
{
	protected static Hashtable colorHash;
	protected static Color keywordColor, typeColor, operatorColor, classColor, stringColor, commentColor, directiveColor;
	
	static
	{
		colorHash = new Hashtable();
		initColors();
	}
	
	/**
	 *	Sets up the color table of the view.
	 **/
	public static void initColors()
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.editor.KeywordColor") == null)
			prefs.setColor("kawigi.editor.KeywordColor", keywordColor = new Color(191, 191, 0));
		else
			keywordColor = prefs.getColor("kawigi.editor.KeywordColor");
		if (prefs.getProperty("kawigi.editor.TypeColor") == null)
			prefs.setColor("kawigi.editor.TypeColor", typeColor = new Color(127, 127, 255));
		else
			typeColor = prefs.getColor("kawigi.editor.TypeColor");
		if (prefs.getProperty("kawigi.editor.OperatorColor") == null)
			prefs.setColor("kawigi.editor.OperatorColor", operatorColor = new Color(191, 63, 63));
		else
			operatorColor = prefs.getColor("kawigi.editor.OperatorColor");
		if (prefs.getProperty("kawigi.editor.ClassColor") == null)
			prefs.setColor("kawigi.editor.ClassColor", classColor = new Color(191, 63, 191));
		else
			classColor = prefs.getColor("kawigi.editor.ClassColor");
		if (prefs.getProperty("kawigi.editor.StringColor") == null)
			prefs.setColor("kawigi.editor.StringColor", stringColor = new Color(255, 0, 0));
		else
			stringColor = prefs.getColor("kawigi.editor.StringColor");
		if (prefs.getProperty("kawigi.editor.CommentColor") == null)
			prefs.setColor("kawigi.editor.CommentColor", commentColor = new Color(127, 255, 127));
		else
			commentColor = prefs.getColor("kawigi.editor.CommentColor");
		if (prefs.getProperty("kawigi.editor.DirectiveColor") == null)
			prefs.setColor("kawigi.editor.DirectiveColor", directiveColor = new Color(255, 127, 127));
		else
			directiveColor = prefs.getColor("kawigi.editor.DirectiveColor");
		
		String[] keywords = new String[]{"abstract", "event", "new", "struct", "as", "explicit", "switch", "base", "extern", "operator", "throw",
		"break", "finally", "out", "fixed", "override", "try", "case", "params", "catch", "for", "private", "foreach", "protected", "checked",
		"goto", "public", "unchecked", "class", "if", "readonly", "unsafe", "const", "implicit", "ref", "continue", "in", "return", "using", "virtual",
		"default", "interface", "sealed", "volatile", "delegate", "internal", "do", "while", "lock", "stackalloc", "else", "static", "enum", "namespace"};
		String[] types = new String[]{"bool", "byte", "char", "decimal", "double", "false", "float", "int", "long", "null", "object", "sbyte", "short", "signed",
			"string", "this", "true", "uint", "ulong", "ushort", "void"};
		String[] operators = new String[]{"is", "operator", "sizeof", "typeof", "+", "-", "=", "|", "*", "&", "^", "%", "!", "~", "/", "<", ">", "?", ":"};
		String[] directives = new String[]{"#define", "#error", "#undef", "#elif", "#if", "#else", "#line", "#endif", "#warning", "#region", "#endregion"};
		//classes, interfaces, structs, delegates and enumerations in System, System.Collections, System.Collections.Specialized,
		//System.Text and System.Text.RegularExpressions.  They seemed like they would be the most useful.  A complete IDE would
		//Also definitely do System.IO, System.WindowsForms and some other stuff.
		String[] classes = new String[]{"Activator", "AppDomain", "AppDomainSetup", "AppDomainUnloadedException", "ApplicationException", "ArgumentException",
			"ArgumentNullException", "ArgumentOutOfRangeException", "ArithmeticException", "Array", "ArrayTypeMismatchException", "AssemblyLoadEventArgs",
			"Attribute", "AttributeUsageAttribute", "BadImageFormatException", "BitConverter", "Buffer", "CannotUnloadAppDomainException", "CharEnumerator",
			"CLSCompliantAttribute", "Console", "ContextBoundObject", "ContextMarshalException", "ContextStaticAttribute", "Convert", "DBNull", "Delegate",
			"DivideByZeroException", "DllNotFoundException", "DuplicateWaitObjectException", "EntryPointNotFoundException", "Enum", "Environment", "EventArgs",
			"Exception", "ExecutionEngineException", "FieldAccessException", "FlagsAttribute", "FormatException", "GC", "IndexOutOfRangeException",
			"InvalidCastException", "InvalidOperationException", "InvalidProgramException", "LoaderOptimizationAttribute", "LocalDataStoreSlot",
			"MarshalByRefObject", "Math", "MemberAccessException", "MethodAccessException", "MissingFieldException", "MissingMemberException",
			"MissingMethodException", "MTAThreadAttribute", "MulticastDelegate", "MulticastNotSupportedException", "NonSerializedAttribute",
			"NotFiniteNumberException", "NotImplementedException", "NotSupportedException", "NullReferenceException", "Object", "ObjectDisposedExeption",
			"ObsoleteException", "OperatingSystem", "OutOfMemoryException", "OverflowException", "ParamArrayAttribute", "PlatformNotSupportedException",
			"Random", "RankException", "ResolveEventArgs", "SerializableAttribute", "StackOverflowException", "STAThreadAttribute", "String",
			"SystemException", "ThreadStaticAttribute", "TimeZone", "Type", "TypeInitializationException", "TypeLoadException", "TypeUnloadedException",
			"UnauthorizedAccessException", "UnhandledExceptionEventArgs", "Uri", "UriBuilder", "UriFormatException", "ValueType", "Version",
			"WeakReference", "IAppDomainSetup", "IAsyncResult", "ICloneable", "IComparable", "IConvertible", "ICustomerFormatter", "IDisposable",
			"IFormatProvider", "IFormattable", "IServiceProvider", "_AppDomain", "ArgIterator", "Boolean", "Byte", "Char", "DateTime", "Decimal",
			"Double", "Guid", "Int16", "Int32", "Int64", "IntPtr", "RuntimeArgumentHandle", "RuntimeFieldHandle", "RuntimeMethodHandle",
			"RuntimeTypeHandle", "SByte", "Single", "TimeSpan", "TypedReference", "UInt16", "UInt32", "UInt64", "UIntPtr", "Void", "AssemblyLoadEventHandler",
			"AsyncCallback", "CrossAppDomainDelegate", "EventHandler", "ResolveEventHandler", "UnhandledExceptionEventHandler", "AttributeTargets",
			"DayOfWeek", "LoaderOptimization", "PlatformID", "TypeCode", "UriHostNameType", "UriPartial", "ArrayList", "BitArray", "CaseInsensitiveComparer",
			"CaseInsensitiveHashCodeProvider", "CollectionBase", "Comparer", "DictionaryBase", "Hashtable", "Queue", "ReadOnlyCollectionBase",
			"SortedList", "Stack", "ICollection", "IComparer", "IDictionary", "IDictionaryEnumerator", "IEnumerable", "IEnumerator", "IHashCodeProvider",
			"IList", "DictionaryEntry", "CollectionsUtil", "HybridDictionary", "ListDictionary", "NameObjectCollectionBase", "NameValueCollection",
			"StringCollection", "StringDictionary", "StringEnumerator", "BitVector32", "ASCIIEncoding", "Decoder", "Encoder", "Encoding", "StringBuilder",
			"UnicodeEncoding", "UTF7Encoding", "UTF8Encoding", "Capture", "CaptureCollection", "Group", "GroupCollection", "Match", "MatchCollection",
			"Regex", "RegexCompilationInfo", "MatchEvaluator", "RegexOptions"};
		for (int i=0; i<keywords.length; i++)
			colorHash.put(keywords[i], keywordColor);
		for (int i=0; i<types.length; i++)
			colorHash.put(types[i], typeColor);
		for (int i=0; i<operators.length; i++)
			colorHash.put(operators[i], operatorColor);
		for (int i=0; i<directives.length; i++)
			colorHash.put(directives[i], directiveColor);
		for (int i=0; i<classes.length; i++)
			colorHash.put(classes[i], classColor);
	}
	
	/**
	 *	Creates a new CSharpView to render this element.
	 **/
	public CSharpView(Element e)
	{
		super(e);
	}
	
	/**
	 *	Overridden from PlainView - this method gets called to render every element
	 *	of unselected text.
	 **/
	protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException
	{
		String s = getDocument().getText(p0, p1 - p0);
		String before = getDocument().getText(0, p0);
		boolean inComment = false;
		for (int i=0; i<before.length(); i++)
		{
			if (inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '*')
				inComment = false;
			else if (!inComment && before.charAt(i) == '*' && i > 0 && before.charAt(i-1) == '/')
				inComment = true;
			else if (!inComment && before.charAt(i) == '\"')
				for (i = i+1; i<before.length() && before.charAt(i) != '\"' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (!inComment && before.charAt(i) == '\'')
				for (i = i+1; i<before.length() && before.charAt(i) != '\'' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (!inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '/')
				for (i = i+1; i<before.length() && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
		}
		return drawTabbedText(s, x, y, g, p0, false, inComment);
	}
	
	/**
	 *	Overridden from PlainView - this method gets called to render every element
	 *	of selected text, so that I could change how it's displayed if I want.
	 **/
	protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException
	{
		String s = getDocument().getText(p0, p1 - p0);
		String before = getDocument().getText(0, p0);
		boolean inComment = false;
		for (int i=0; i<before.length(); i++)
		{
			if (inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i-1) == '*')
				inComment = false;
			else if (!inComment && before.charAt(i) == '*' && i > 0 && before.charAt(i-1) == '/')
				inComment = true;
			else if (!inComment && before.charAt(i) == '\"')
				for (i = i+1; i<before.length() && before.charAt(i) != '\"' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (!inComment && before.charAt(i) == '\'')
				for (i = i+1; i<before.length() && before.charAt(i) != '\'' && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
			else if (!inComment && before.charAt(i) == '/' && i > 0 && before.charAt(i) == '/')
				for (i = i+1; i<before.length() && before.charAt(i) != '\r' && before.charAt(i) != '\n'; i++)
					;
		}
		return drawTabbedText(s, x, y, g, p0, true, inComment);
	}
	
	/**
	 *	Renders the text segment onto the given Grapnics context.
	 *	
	 *	Originally, this looked a lot like javax.swing.text.Utilities.drawTabbedText
	 *	with a little bit of tokenizing, but now it's pretty much modified to my own
	 *	style.  Unfortunately, at some point in time, my indentation got all weird
	 *	(probably as a result of me using tabs and the original implementation mixing
	 *	spaces and tabs), so there may be some weird-looking parts left in the code.
	 *	
	 *	This is the magic of my syntax hilighting.
	 **/
	protected int drawTabbedText(String s, int x, int y, Graphics g, int startOffset, boolean selected, boolean inComment)
	{
		if (selected)
			g.setColor(((JTextComponent)getContainer()).getSelectedTextColor());
		FontMetrics metrics = g.getFontMetrics();
		int flushIndex = 0;
		for (int i = 0; i < s.length(); i++)
		{
			//multi-line comment state
			if (s.charAt(i) == '/' && i < s.length()-1 && s.charAt(i+1) == '*')
				inComment = true;
			//If you start a string, make sure you end it!
			if (!inComment && s.charAt(i) == '\"')
			{
				if (flushIndex < i)
				{
					if (!selected)
						if (inComment)
							g.setColor(commentColor);
						else
							g.setColor(getColor(s.substring(flushIndex, i)));
					g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
					flushIndex = i;
				}
				i++;
				for (; i<s.length() && s.charAt(i) != '\"' && s.charAt(i) != '\n' && s.charAt(i) != '\r'; i++)
				{
					if (s.charAt(i) == '\t')
					{
						if (i > flushIndex)
						{
							if (!selected)
		    						g.setColor(stringColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
						}
						flushIndex = i + 1;
						x = (int)nextTabStop((float)x, startOffset+i);
					}
					if (s.charAt(i) == '\\')
						i++;
				}
				if (!selected)
					if (inComment)
						g.setColor(commentColor);
					else
			    		g.setColor(stringColor);
				g.drawString(s.substring(flushIndex, i), x, y);
				x += metrics.stringWidth(s.substring(flushIndex, i));
				if (i < s.length() && s.charAt(i) == '\"')
				{
					g.drawString(s.substring(i, i+1), x, y);
			    	x += metrics.charWidth(s.charAt(i));
			   	}
	    		flushIndex = i+1;
			}
			//I basically treat characters like Strings (so the text will be colored
			//after the character if you forget to close it).
			else if (!inComment && s.charAt(i) == '\'')
			{
	    		if (flushIndex < i)
	    		{
					if (!selected)
						if (inComment)
							g.setColor(commentColor);
						else
			    			g.setColor(getColor(s.substring(flushIndex, i)));
		   	 		g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
		    		flushIndex = i;
		    	}
				i++;
				for (; i<s.length() && s.charAt(i) != '\'' && s.charAt(i) != '\n' && s.charAt(i) != '\r'; i++)
				{
					if (s.charAt(i) == '\t')
					{
						if (i > flushIndex)
						{
							if (!selected)
		    						g.setColor(stringColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
						}
						flushIndex = i + 1;
						x = (int)nextTabStop((float)x, startOffset+i);
					}
					if (s.charAt(i) == '\\')
						i++;
				}
				if (!selected)
					if (inComment)
						g.setColor(commentColor);
					else
			    		g.setColor(stringColor);
				g.drawString(s.substring(flushIndex, i), x, y);
				x += metrics.stringWidth(s.substring(flushIndex, i));
				if (i < s.length() && s.charAt(i) == '\'')
				{
					g.drawString(s.substring(i, i+1), x, y);
			    	x += metrics.charWidth(s.charAt(i));
			    }
		    	flushIndex = i+1;
			}
			//Single-line comments:
			else if (!inComment && s.charAt(i) == '/' && i < s.length()-1 && s.charAt(i+1) == '/')
			{
				if (flushIndex < i)
	    		{
					if (!selected)
						if (inComment)
							g.setColor(commentColor);
						else
				    		g.setColor(getColor(s.substring(flushIndex, i)));
			    	g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
			    	flushIndex = i;
		    	}
				for (; i<s.length() && s.charAt(i) != '\n' && s.charAt(i) != '\r'; i++)
				{
					if (s.charAt(i) == '\t')
					{
						if (i > flushIndex)
						{
							if (!selected)
		    					g.setColor(commentColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
						}
						flushIndex = i + 1;
						x = (int)nextTabStop((float)x, startOffset+i);
					}
				}
				if (!selected)
					g.setColor(commentColor);
				//Me glorifying myself.  What can I say?
				if (s.substring(flushIndex, i).endsWith("[KawigiEdit]"))
			   	{
			   		if (!s.substring(flushIndex, i).equals("[KawigiEdit]"))
			   		{
			   			if (!selected)
			   				g.setColor(commentColor);
			   			g.drawString(s.substring(flushIndex, s.indexOf("[KawigiEdit]", flushIndex)), x, y);
			   			x += metrics.stringWidth(s.substring(flushIndex, s.indexOf("[KawigiEdit]", flushIndex)));
			   		}
			   		Font oldFont = g.getFont();
			   		g.setFont(oldFont.deriveFont(Font.BOLD));
			    	if (!selected)
				   		g.setColor(getContainer().getForeground());
			    	g.drawString("[KawigiEdit]", x, y);
					x += g.getFontMetrics().stringWidth(s.substring(flushIndex, i));
			    	if (!selected)
				   		g.setColor(Color.red);
		    		g.drawString("Edit", x+g.getFontMetrics().stringWidth("[Kawigi"), y);
			   		g.setFont(oldFont);
			   	}
			   	else
			   	{
					g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
				}
	    		flushIndex = i+1;
			}
			//Tabs special case - I do my tab expansion, and tabs are non-displayable,
			//anyways.
			else if (s.charAt(i) == '\t')
			{
				if (i > flushIndex)
				{
					if (!selected)
						g.setColor(getColor(s.substring(flushIndex, i)));
					g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
				}
				flushIndex = i + 1;
				x = (int) nextTabStop((float) x, startOffset+i);
			}
			//end of line
			else if ((s.charAt(i) == '\n') || (s.charAt(i) == '\r'))
			{
				if (i > flushIndex)
				{
					if (!selected)
						if (inComment)
							g.setColor(commentColor);
						else
			    			g.setColor(getColor(s.substring(flushIndex, i)));
					g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
				}
				flushIndex = i + 1;
	    	}
	    	//parsing compiler directives:
	    	else if (!inComment && s.charAt(i) == '#')
	    	{
	    		if (flushIndex < i)
	    		{
					if (!selected)
			    		g.setColor(getColor(s.substring(flushIndex, i)));
		    		g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
		   	 		flushIndex = i;
		    	}
				i++;
				for (; i<s.length() && s.charAt(i) != '\n' && s.charAt(i) != '\r' && (s.charAt(i) != '/' || i+1 >= s.length() || (s.charAt(i+1) != '/' && s.charAt(i+1) != '*')); i++)
				{
					if (s.charAt(i) == '\t')
					{
						if (i > flushIndex)
						{
							if (!selected)
		    					g.setColor(directiveColor);
							g.drawString(s.substring(flushIndex, i), x, y);
							x += metrics.stringWidth(s.substring(flushIndex, i));
						}
						flushIndex = i + 1;
						x = (int)nextTabStop((float)x, startOffset+i);
					}
				}
				i--;
				if (i >= flushIndex)
				{
					if (!selected)
				    	g.setColor(getColor(s.substring(flushIndex, i+1).split("[ \\t\\n\\r\\f]")[0]));
					g.drawString(s.substring(flushIndex, i+1), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i+1));
				}
				flushIndex = i+1;
	    	}
	    	//valid token characters:
			else if (Character.isLetterOrDigit(s.charAt(i)) || s.charAt(i) == '_')
			{
			}
			//Otherwise flush the buffer!
		    else
		    {
		    	//if the buffer isn't empty, take all previous characters in the
		    	//buffer and flush them together (checking if they make up a token)
		    	if (flushIndex < i)
		    	{
					if (!selected)
						if (inComment)
							g.setColor(commentColor);
						else
							g.setColor(getColor(s.substring(flushIndex, i)));
					g.drawString(s.substring(flushIndex, i), x, y);
					x += metrics.stringWidth(s.substring(flushIndex, i));
				}
				//now draw the current character.
				if (!selected)
					if (inComment)
						g.setColor(commentColor);
					else
		    			g.setColor(getColor(s.substring(i, i+1)));
				g.drawString(s.substring(i, i+1), x, y);
				x += metrics.charWidth(s.charAt(i));
				flushIndex = i+1;
			}
			if (i < s.length() && s.charAt(i) == '/' && i > 0 && s.charAt(i-1) == '*')
				inComment = false;
		}
		//If there's anything left in here, flush it to the screen!
		if (flushIndex < s.length())
		{
			if (!selected)
				if (inComment)
					g.setColor(commentColor);
				else
					g.setColor(getColor(s.substring(flushIndex, s.length())));
			g.drawString(s.substring(flushIndex, s.length()), x, y);
			x += metrics.stringWidth(s.substring(flushIndex, s.length()));
		}
		return x;
	}
	
	/**
	 *	Returns the color to use on the given token.
	 *	
	 *	This will return the default foreground color if no special color is 
	 *	assigned to that token.
	 **/
	protected Color getColor(String word)
	{
		if (colorHash.containsKey(word))
			return (Color)colorHash.get(word);
		else
			return getContainer().getForeground();
	}
	
	/**
	 *	Extension to the generic getIntervals() implementation for C#.
	 *	
	 *	Includes #if..#endif and #region..#endregion.
	 **/
	public ArrayList getIntervals()
	{
		ArrayList ret = super.getIntervals();
		try
		{
			parseIndex = 0;
			lineIndex = 1;
			findIntervals(ret, getDocument().getText(0, getDocument().getLength()), new String[]{"#if", "#endif"});
			parseIndex = 0;
			lineIndex = 1;
			findIntervals(ret, getDocument().getText(0, getDocument().getLength()), new String[]{"#region", "#endregion"});
		}
		catch (BadLocationException ex)
		{
		}
		return ret;
	}
}
