package kawigi.tools.reflect;
import java.lang.reflect.*;
import java.util.*;
import java.io.File;

public class PackageNode implements ReflectorTreeElement
{
	private Vector children;
	private String packagename;
	private HashMap subpackages;
	
	public PackageNode(String packagename)
	{
		this.packagename = packagename;
		children = new Vector();
		subpackages = new HashMap();
	}
	
	public void addClass(String filename) throws ClassNotFoundException
	{
		String oldfilename = filename;
		String expectedDirectory = packagename.replace('.', '/');
		if (!filename.startsWith(expectedDirectory))
			throw new IllegalArgumentException("Class being added is not in this package : " + packagename + " : " + filename);
		filename = filename.substring(expectedDirectory.length());
		if (filename.startsWith("/"))
			filename = filename.substring(1);
		if (filename.indexOf('/') >= 0)
		{
			String nextPackage = filename.substring(0, filename.indexOf('/'));
			if (!subpackages.containsKey(nextPackage))
			{
				PackageNode subpackage = new PackageNode((packagename.length() == 0 ? "" : packagename + ".") + nextPackage);
				subpackages.put(nextPackage, subpackage);
				children.insertElementAt(subpackage, 0);
			}
			PackageNode subpackage = (PackageNode)subpackages.get(nextPackage);
			subpackage.addClass(oldfilename);
		}
		else
		{
			if (filename.endsWith(".class"))
				filename = filename.substring(0, filename.lastIndexOf('.'));
			try
			{
				Class cls = Class.forName(packagename + "." + filename);
				children.add(new ClassNode(cls));
			}
			catch (Throwable t)
			{
				children.add(new ErrorNode(t.getMessage() + " ( loading class " + packagename + "." + filename + " )"));
			}
		}
	}
	
	public ReflectorTreeElement getChild(int index)
	{
		return (ReflectorTreeElement)children.elementAt(index);
	}
	
	public int children()
	{
		return children.size();
	}
	
	public String toString()
	{
		if (packagename.length() == 0)
			return "root package";
		else
			return packagename.indexOf('.') >= 0 ? packagename.substring(packagename.lastIndexOf('.')+1) : packagename;
	}
}
