package kawigi.tools.reflect;
import java.lang.reflect.*;

public class MethodNode implements ReflectorTreeElement
{
	private Method method;
	public MethodNode(Method method)
	{
		this.method = method;
	}
	
	public ReflectorTreeElement getChild(int index)
	{
		return null;
	}
	
	public int children()
	{
		return 0;
	}
	
	public String toString()
	{
		String ret = Modifier.toString(method.getModifiers()) + " " + method.getReturnType().getName() + " " + method.getName() + "(";
		Class[] paramTypes = method.getParameterTypes();
		for (int i=0; i<paramTypes.length; i++)
			ret += paramTypes[i].getName() + ",";
		if (ret.endsWith(","))
			ret = ret.substring(0, ret.length()-1);
		ret += ")";
		Class[] exceptions = method.getExceptionTypes();
		if (exceptions.length > 0)
		{
			ret += " throws " + exceptions[0].getName();
			for (int i=1; i<exceptions.length; i++)
				ret += ", " + exceptions[i].getName();
		}
		return ret;
	}	
}
