package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import javax.swing.text.*;
import kawigi.editor.*;
import java.io.File;
import com.topcoder.client.contestApplet.common.LocalPreferences;

/**
 *	VisualBasic implementation of the ExtendedLanguage interface.
 **/
public class ExtendedVBLanguage extends LanguageContainer
{
	/**
	 *	A singleton instance of the extended Visual Basic language, sort of like how TC does it.
	 **/
	public static final ExtendedVBLanguage EXTENDED_VB_LANGUAGE = new ExtendedVBLanguage();
	
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".filename") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".filename", "$PROBLEM$.vb");
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".compiler") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".compiler", "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\vbc.exe\" $PROBLEM$.vb");
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".run") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".run", "\"$CWD$" + File.separator + "$PROBLEM$.exe\"");
		if (prefs.getProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".imports") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_VB_LANGUAGE.getPropertyClass() + ".imports", "Microsoft.VisualBasic,System,System.Collections,System.Text");
	}
	/**
	 *	Creates a new instance of the ExtendedLanguage that uses settings from the given TC Language.
	 *	
	 *	This object will behave strangely if lang is not a VBLanguage instance.
	 **/
	public ExtendedVBLanguage(Language lang)
	{
		super(lang);
	}
	
	/**
	 *	Creates a new instance of the ExtendedLanguage that uses TC's singleton VB language instance.
	 **/
	public ExtendedVBLanguage()
	{
		super(VBLanguage.VB_LANGUAGE);
	}
	
	/**
	 *	Returns at a class and method declaration, with a main method that has testing code.
	 *	
	 *	As some of my first Visual Basic code comes out of this method, I wouldn't be offended
	 *	if someone else came and reimplemented it, but it at least seems to generate <i>correct</i>
	 *	code, so we'll leave it at that for now.
	 **/
	public Skeleton getSkeleton(ProblemComponent comp)
	{
		String skeleton = "";
		LocalPreferences prefs = LocalPreferences.getInstance();
		String[] imports = prefs.getProperty("kawigi.language." + getPropertyClass() + ".imports").split(",");
		for (int i=0; i<imports.length; i++)
			skeleton += "Imports " + imports[i] + "\n";
		skeleton += "\nPublic Class " + comp.getClassName() + "\n";
		skeleton += "\tPublic Function " + comp.getMethodName() + "(";
		String[] paramNames = comp.getParamNames();
		DataType[] paramTypes = comp.getParamTypes();
		skeleton += "ByVal " + paramNames[0] + " As " + paramTypes[0].getDescriptor(this);
		for (int i=1; i<paramNames.length; i++)
			skeleton += ", ByVal " + paramNames[i] + " As " + paramTypes[i].getDescriptor(this);
		skeleton += ") As " + comp.getReturnType().getDescriptor(this) + "\n\t\t\n";
		int caret = skeleton.length()-1;
		skeleton += "\tEnd Function\n";
		skeleton += "End Class\n";
		skeleton += "\nModule MainModule\n";
		skeleton += "\tSub Main()\n";
		TestCase[] cases = comp.getTestCases();
		//skeleton += "\t\tlong time;\n";
		String returnType = comp.getReturnType().getDescriptor(this);
		skeleton += "\t\tDim Errors As Boolean = False\n";
		skeleton += "\t\tDim Answer, DesiredAnswer As " + returnType + "\n";
		skeleton += "\t\tDim Obj As " + comp.getClassName() + "\n";
		skeleton += "\t\tDim Time As DateTime\n";
		if (returnType.endsWith("()"))
		{
			skeleton += "\t\tDim Same As Boolean\n";
			skeleton += "\t\tDim i As Integer\n";
		}
		boolean stringType = returnType.startsWith("String");
		for (int i=0; i<cases.length; i++)
		{
			//skeleton += "\t\ttime = System.currentTimeMillis();\n";
			skeleton += "\t\tObj = New " + comp.getClassName() + "()\n";
			skeleton += "\t\tTime = DateTime.Now\n";
			skeleton += "\t\tAnswer = Obj." + comp.getMethodName() + "(" + toTest(cases[i], paramTypes) + ")\n";
			skeleton += "\t\tConsole.WriteLine(\"Time: \" & (DateTime.Now.Subtract(Time)).TotalSeconds & \" seconds\")\n";
			skeleton += "\t\tDesiredAnswer = " + translateObject(returnType, cases[i].getOutput()) + "\n";
			//skeleton += "\t\tSystem.out.println(\"Time: \" + (System.currentTimeMillis()-time)/1000.0 + \" seconds\");\n";
			skeleton += "\t\tConsole.WriteLine(\"Your Answer:\")\n";
			if (returnType.endsWith("()"))
			{
				skeleton += "\t\tConsole.Write(\"{ \")\n";
				skeleton += "\t\tIf (Answer.Length > 0) Then\n";
				skeleton += "\t\t\tConsole.Write(" + (stringType ? "\"\"\"\" & " : "") + "Answer(0)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				skeleton += "\t\t\tFor i = 1 To Answer.Length - 1\n";
				skeleton += "\t\t\t\tConsole.Write(\"\t, " + (stringType ? "\"\"" : "") + "\" & Answer(i)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				skeleton += "\t\t\tNext\n";
				skeleton += "\t\t\tConsole.WriteLine(\" }\")\n";
				skeleton += "\t\tElse\n";
				skeleton += "\t\t\tConsole.WriteLine(\"}\")\n";
				skeleton += "\t\tEnd If\n";
				skeleton += "\t\tConsole.WriteLine(\"Desired Answer:\")\n";
				skeleton += "\t\tConsole.Write(\"{ \")\n";
				skeleton += "\t\tSame = (Answer.Length = DesiredAnswer.Length)\n";
				skeleton += "\t\tIf (Answer.Length > 0) Then\n";
				skeleton += "\t\t\tConsole.Write(" + (stringType ? "\"\"\"\" & " : "") + "DesiredAnswer(0)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				skeleton += "\t\t\tIf Answer(0) <> DesiredAnswer(0) Then\n";
				skeleton += "\t\t\t\tSame = False\n";
				skeleton += "\t\t\tEnd If\n";
				skeleton += "\t\t\tFor i = 1 To DesiredAnswer.Length - 1\n";
				skeleton += "\t\t\t\tConsole.Write(\"\t, " + (stringType ? "\"\"" : "") + "\" & DesiredAnswer(i)" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				skeleton += "\t\t\t\tIf Answer(i) <> DesiredAnswer(i) Then\n";
				skeleton += "\t\t\t\t\tSame = False\n";
				skeleton += "\t\t\t\tEnd If\n";
				skeleton += "\t\t\tNext\n";
				skeleton += "\t\t\tConsole.WriteLine(\" }\")\n";
				skeleton += "\t\tElse\n";
				skeleton += "\t\t\tConsole.WriteLine(\"}\")\n";
				skeleton += "\t\tEnd If\n";
				skeleton += "\t\tIf Same Then\n";
				skeleton += "\t\t\tConsole.WriteLine(\"Match :-)\")\n";
				skeleton += "\t\tElse\n";
				skeleton += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\")\n";
				skeleton += "\t\t\tErrors = True\n";
				skeleton += "\t\tEnd If\n";
			}
			else
			{
				skeleton += "\t\tConsole.WriteLine(\"\t" + (stringType ? "\"\"" : "") + "\" & Answer" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				skeleton += "\t\tConsole.WriteLine(\"Desired Answer:\")\n";
				skeleton += "\t\tConsole.WriteLine(\"\t" + (stringType ? "\"\"" : "") +"\" & DesiredAnswer" + (stringType ? " & \"\"\"\"" : "") + ")\n";
				skeleton += "\t\tIf Answer = DesiredAnswer Then\n";
				skeleton += "\t\t\tConsole.WriteLine(\"Match :-)\")\n";
				skeleton += "\t\tElse\n";
				skeleton += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\")\n";
				skeleton += "\t\t\tErrors = True\n";
				skeleton += "\t\tEnd If\n";
			}
			skeleton += "\t\tConsole.WriteLine()\n";
		}
		skeleton += "\t\t\n\t\tIf Errors Then\n";
		skeleton += "\t\t\tConsole.WriteLine(\"Some of the test cases had errors :-(\")\n";
		skeleton += "\t\tElse\n";
		skeleton += "\t\t\tConsole.WriteLine(\"You're a stud (at least on the test data)! :-D \")\n";
		skeleton += "\t\tEnd If\n";
		skeleton += "\tEnd Sub\n";
		skeleton += "End Module\n";
		skeleton += "\n'Powered by [KawigiEdit]\n";
		return new Skeleton(skeleton, caret);
	}
	
	/**
	 *	Quick utility function to provide the code that should return the parameter list for the function.
	 **/
	private String toTest(TestCase test, DataType[] types)
	{
		String[] input = test.getInput();
		String ret = translateObject(types[0].getDescriptor(this), input[0]);
		for (int i=1; i<input.length; i++)
			ret += ", " + translateObject(types[i].getDescriptor(this), input[i]);
		ret = ret.replaceAll("\\n", "");
		return ret;
	}
	
	/**
	 *	Quck utility function to convert a string value from TC to code that creates that value in VB.
	 **/
	private static String translateObject(String type, String value)
	{
		if (type.endsWith("()"))
			return "New " + type + value;
		else
			return value;
	}
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.  And how platform-independent is Microsoft Visual Basic .NET, anyways?
	 **/
	public String getCompileCommand(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".compiler";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\vbc.exe\" $PROBLEM$.vb");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".run";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"$CWD$" + File.separator + "$PROBLEM$");
		command = command.replaceAll("\\$CWD\\$", cwd.getPath());
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".filename";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "$PROBLEM$.vb");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the class of the VB implementation of a View
	 **/
	public Class getViewClass()
	{
		return VBView.class;
	}
}