package kawigi.editor;
import javax.swing.*;
import javax.swing.text.*;
import com.topcoder.shared.language.*;
import kawigi.language.*;
import java.awt.*;

/**
 *	This class was originally just a hack on JTextPane to stop it from wrapping
 *	lines, as there is no setting or method to do this normally.
 *	
 *	It's also annoying, really.  Although using my own version of a JTextPane has
 *	come in useful since then, really the line wrapping is still the main special
 *	functionality in here.
 **/
public class NoWrapJTextPane extends JTextPane
{
	/**
	 *	Creates a new <code>NoWrapJTextPane</code> and sets it to use various 
	 *	versions of my EditorKit implementation based on a few mime types.
	 *	
	 *	The special mime types it will now know are text/Java, text/C++, text/C#
	 *	and text/VB.
	 **/
	public NoWrapJTextPane()
	{
		//This is a convenient way to do this :-)
		doContentType(ExtendedJavaLanguage.EXTENDED_JAVA_LANGUAGE);
		doContentType(ExtendedCPPLanguage.EXTENDED_CPP_LANGUAGE);
		doContentType(ExtendedCSharpLanguage.EXTENDED_CSHARP_LANGUAGE);
		doContentType(ExtendedVBLanguage.EXTENDED_VB_LANGUAGE);
	}
	
	/**
	 *	Given an ExtendedLanguage, creates an EditorKit that uses the appropriate
	 *	view class and sets it to use that editor kit for the mime type associated
	 *	with that lanugage (i.e. - text/<language name>).
	 **/
	private void doContentType(ExtendedLanguage lang)
	{
		setEditorKitForContentType("text/" + lang.getName(), new ConfigurableEditorKit(lang.getViewClass()));
	}
	
	/**
	 * It's brutally annoying that I have to write this, and sometimes it doesn't even quite work.
	 **/
	public boolean getScrollableTracksViewportWidth()
	{
		return getParent() instanceof JViewport && ((JViewport)getParent()).getWidth() >= getUI().getPreferredSize(this).width;	//all this to just not wrap?  Why isn't there some good way to set this already?
	}
	
	/**
	 *	Tweak of the default block scolling increment.
	 *	
	 *	It <strong>should</strong> scroll by the height (or width) - font size.
	 **/
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return super.getScrollableBlockIncrement(visibleRect, orientation, direction)-getFont().getSize();
	}
	
	/**
	 *	Tweak of the default unit scrolling increment.
	 *	
	 *	The default seemed to scroll on pixel at a time, which I found rather useless.  It took way too
	 *	long to scroll a few lines.  So now it scrolls roughly 1 1/2 lines at a time.
	 *	
	 *	I mentioned this plugin to NeverMore once, and he drilled me with questions about it.  Then he
	 *	got ready to ask me something that I could tell was important to him that he was missing in PopsEdit -
	 *	and it was wheel scrolling.  People get attached to their mouse wheels, what can I say?  I said it
	 *	worked and he was ecstatic.  Not only that, but the scrolling increment had been tweaked to be "just
	 *	right", since the latest version was the one where I added this tweak.  It was funny to see him so
	 *	impressed, I wasn't aware that PopsEdit had wheel scrolling turned off.
	 **/
	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return 3*getFont().getSize()/2;
	}
	
	/**
	 *	By default, use my GenericView to render the text.
	 *
	 *  This will be changed whenever someone looks at the problem in a specific language.
	 **/
	protected EditorKit createDefaultEditorKit()
	{
		//Hey!  Use my EditorKit!
		return new ConfigurableEditorKit(VBView.class);
	}
}