package kawigi.config;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 *	A colored button that brings up a JColorChooser when pressed.
 **/
public class ColorWidget extends JComponent implements MouseListener
{
	/**
	 *	The currently selected color.
	 **/
	private Color color;
	
	/**
	 *	The state of the button - whether it is pushed in or not.
	 **/
	private boolean depressed;
	
	/**
	 *	Creates a new ColorWidget with a color of black.
	 **/
	public ColorWidget()
	{
		this(Color.black);
	}
	
	/**
	 *	Creates a new ColorWidget with c as its current color.
	 **/
	public ColorWidget(Color c)
	{
		color = c;
		depressed = false;
		addMouseListener(this);
		setPreferredSize(new Dimension(50, 20));
	}
	
	/**
	 *	Returns the currently selected color.
	 **/
	public Color getColor()
	{
		return color;
	}
	
	/**
	 *	Sets the currently selected color.
	 **/
	public void setColor(Color c)
	{
		color = c;
	}
	
	/**
	 *	Drawing method.
	 **/
	public void paintComponent(Graphics g)
	{
		g.setColor(color);
		g.fill3DRect(0, 0, getWidth(), getHeight(), !depressed);
	}
	
	/**
	 *	Sets the depressed attribute to true, and updates the display.
	 **/
	public void mousePressed(MouseEvent e)
	{
		depressed = true;
		repaint();
	}
	
	/**
	 *	If the button was depressed before, fires the color chooser.
	 *	
	 *	Also sets the depressed flag to false and redraws.
	 **/
	public void mouseReleased(MouseEvent e)
	{
		if (depressed)
		{
			Color newcolor = JColorChooser.showDialog(this, "Select a Color", color);
			if (newcolor != null)
				color = newcolor;
		}
		depressed = false;
		repaint();
	}
	
	/**
	 *	Sets the depressed flag to false when the mouse pointer leaves the area
	 *	of the button.
	 **/
	public void mouseExited(MouseEvent e)
	{
		depressed = false;
		repaint();
	}
	
	/**
	 *	Empty - part of interface MouseListener
	 **/
	public void mouseEntered(MouseEvent e){}
	
	/**
	 *	Empty - part of interface MouseListener
	 **/
	public void mouseClicked(MouseEvent e){}
}