package kawigi.tools.reflect;
import java.lang.reflect.*;

public class ConstructorNode implements ReflectorTreeElement
{
	private Constructor constr;
	public ConstructorNode(Constructor constr)
	{
		this.constr = constr;
	}
	
	public ReflectorTreeElement getChild(int index)
	{
		return null;
	}
	
	public int children()
	{
		return 0;
	}
	
	public String toString()
	{
		String ret = Modifier.toString(constr.getModifiers()) + " " + constr.getName() + "(";
		Class[] paramTypes = constr.getParameterTypes();
		for (int i=0; i<paramTypes.length; i++)
			ret += paramTypes[i].getName() + ",";
		if (ret.endsWith(","))
			ret = ret.substring(0, ret.length()-1);
		ret += ")";
		Class[] exceptions = constr.getExceptionTypes();
		if (exceptions.length > 0)
		{
			ret += " throws " + exceptions[0].getName();
			for (int i=1; i<exceptions.length; i++)
				ret += ", " + exceptions[i].getName();
		}
		return ret;
	}	
}
