package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import javax.swing.text.*;
import kawigi.editor.*;
import java.io.File;
import com.topcoder.client.contestApplet.common.LocalPreferences;

public class ExtendedJavaLanguage extends LanguageContainer
{
	/**
	 *	A singleton instance of the extended Java language.
	 **/
	public static final ExtendedJavaLanguage EXTENDED_JAVA_LANGUAGE = new ExtendedJavaLanguage();
	
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.language." + EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".filename") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".filename", "$PROBLEM$.java");
		if (prefs.getProperty("kawigi.language." + EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".compiler") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".compiler", "javac $PROBLEM$.java");
		if (prefs.getProperty("kawigi.language." + EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".run") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_JAVA_LANGUAGE.getPropertyClass() + ".run", "java $PROBLEM$");
	}
	
	/**
	 *	Creates a new instance of the ExtendedLanguage that uses settings from the given TC Language.
	 *	
	 *	This object will behave strangely if lang is not a VBLanguage instance.
	 **/
	public ExtendedJavaLanguage(Language lang)
	{
		super(lang);
	}
	
	/**
	 *	Creates a new instance of the ExtendedLanguage that uses TC's singleton VB language instance.
	 **/
	public ExtendedJavaLanguage()
	{
		super(JavaLanguage.JAVA_LANGUAGE);
	}
	
	/**
	 *	Returns at a class and method declaration, with a main method that has testing code.
	 **/
	public Skeleton getSkeleton(ProblemComponent comp)
	{
		
		String skeleton = "import java.util.*;\n";
		skeleton += "import java.util.regex.*;\n";
		skeleton += "import java.text.*;\n";
		skeleton += "import java.math.*;\n";
		skeleton += "import java.awt.geom.*;\n\n";
		skeleton += "public class " + comp.getClassName() + "\n{\n";
		skeleton += "\tpublic " + comp.getReturnType(getId()) + " " + comp.getMethodName() + "(";
		String[] paramNames = comp.getParamNames();
		DataType[] paramTypes = comp.getParamTypes();
		skeleton += paramTypes[0].getDescriptor(this) + " " + paramNames[0];
		for (int i=1; i<paramNames.length; i++)
			skeleton += ", " + paramTypes[i].getDescriptor(this) + " " + paramNames[i];
		skeleton += ")\n\t{\n";
		skeleton += "\t\t\n";
		int caret = skeleton.length()-1;
		skeleton += "\t}\n\t\n";
		skeleton += "\tpublic static void main(String[] args)\n\t{\n";
		TestCase[] cases = comp.getTestCases();
		skeleton += "\t\tlong time;\n";
		String returnType = comp.getReturnType().getDescriptor(this);
		skeleton += "\t\t" + returnType + " answer;\n";
		skeleton += "\t\tboolean errors = false;\n";
		boolean stringType = returnType.toLowerCase().startsWith("string");
		skeleton += "\t\tString answerString, desiredAnswerString;\n\t\t\n";
		for (int i=0; i<cases.length; i++)
		{
			skeleton += "\t\ttime = System.currentTimeMillis();\n";
			skeleton += "\t\tanswer = " + toJavaTest(cases[i], paramTypes, "new " + comp.getClassName() + "()." + comp.getMethodName() + "(");
			skeleton += "\t\tSystem.out.println(\"Time: \" + (System.currentTimeMillis()-time)/1000.0 + \" seconds\");\n";
			skeleton += "\t\tSystem.out.println(\"Your answer:\");\n";
			if (returnType.endsWith("[]"))
			{
				skeleton += "\t\tanswerString = \"{ \";\n";
				skeleton += "\t\tif (answer.length > 0)\n";
				skeleton += "\t\t{\n";
				skeleton += "\t\t\tanswerString += " + (stringType ? "\"\\\"\" + " : "") + "answer[0]" + (stringType ? " + \"\\\"\"" : "") + ";\n";
				skeleton += "\t\t\tfor (int i=1; i<answer.length; i++)\n";
				skeleton += "\t\t\t\tanswerString += \",  " + (stringType ? "\\\"" : "") + "\" + answer[i]" + (stringType ? " + \"\\\"\"" : "") + ";\n";
				skeleton += "\t\t}\n";
				skeleton += "\t\telse\n";
				skeleton += "\t\t\tanswerString = \"{\";\t//getting spacing right\n";
				skeleton += "\t\tanswerString += \" }\";\n";
			}
			else
				skeleton += "\t\tanswerString = \"" + (stringType ? "\\\"" : "") +"\" + answer" + (stringType ? " + \"\\\"\"" : "") + ";\n";
			skeleton += "\t\tSystem.out.println(\"\\t\" + answerString);\n";
			//If writing code that writes code isn't confusing enough, maybe writing code that writes code that writes code-like constructs is.
			skeleton += "\t\tdesiredAnswerString = \"" + cases[i].getOutput().replaceAll("\\\"", "\\\\\\\"") + "\";\n";
			skeleton += "\t\tSystem.out.println(\"Desired answer:\\n\\t\" + desiredAnswerString);\n";
			skeleton += "\t\tif (!answerString.equals(desiredAnswerString))\n";
			skeleton += "\t\t{\n";
			skeleton += "\t\t\terrors = true;\n";
			skeleton += "\t\t\tSystem.out.println(\"DOESN'T MATCH!!!!\");\n";
			skeleton += "\t\t}\n";
			skeleton += "\t\telse\n";
			skeleton += "\t\t\tSystem.out.println(\"Match :-)\");\n";
			skeleton += "\t\tSystem.out.println();\n";
		}
		skeleton += "\t\t\n\t\tif (errors)\n";
		skeleton += "\t\t\tSystem.out.println(\"Some of the test cases had errors :-(\");\n";
		skeleton += "\t\telse\n";
		skeleton += "\t\t\tSystem.out.println(\"You're a stud (at least on the test data)! :-D \");\n";
		skeleton += "\t}\n}\n";
		skeleton += "\n//Powered by [KawigiEdit]\n";
		return new Skeleton(skeleton, caret);
	}
	
	/**
	 *	Quick utility function to provide the code that should return the answer.
	 **/
	private String toJavaTest(TestCase test, DataType[] types, String start)
	{
		String ret = start;
		String[] input = test.getInput();
		ret += translateObject(types[0].getDescriptor(this), input[0]);
		for (int i=1; i<input.length; i++)
			ret += ", " + translateObject(types[i].getDescriptor(this), input[i]);
		ret = ret.replaceAll("\\n", "");
		return ret + ");\n";
	}
	
	/**
	 *	Quck utility function to convert a value to code that creates that value in Java.
	 **/
	private static String translateObject(String type, String value)
	{
		if (type.endsWith("[]"))
			return "new " + type + value;
		else
			return value;
	}
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.
	 **/
	public String getCompileCommand(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".compiler";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "javac $PROBLEM$.java");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".run";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "java $PROBLEM$");
		command = command.replaceAll("\\$CWD\\$", cwd.getPath());
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".filename";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "$PROBLEM$.java");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the class of the Java implementation of a View
	 **/
	public Class getViewClass()
	{
		return JavaView.class;
	}
}