package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import com.topcoder.shared.netCommon.*;
import javax.swing.text.*;
import kawigi.editor.*;
import java.io.File;
import com.topcoder.client.contestApplet.common.LocalPreferences;

public class ExtendedCSharpLanguage extends LanguageContainer
{
	/**
	 *	A singleton instance of the extended C# language.
	 **/
	public static final ExtendedCSharpLanguage EXTENDED_CSHARP_LANGUAGE = new ExtendedCSharpLanguage();
	
	static
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".filename") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".filename", "$PROBLEM$.cs");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".compiler") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".compiler", "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\csc.exe\" $PROBLEM$.cs");
		if (prefs.getProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".run") == null)
			prefs.setProperty("kawigi.language." + EXTENDED_CSHARP_LANGUAGE.getPropertyClass() + ".run", "\"$CWD$" + File.separator + "$PROBLEM$.exe\"");
	}
	
	/**
	 *	Constructs a new extended C# language based on <code>lang</code>.
	 *	
	 *	If <code>lang</code> is not an instance of CSharpLanguage, this class may not function normally.
	 **/
	public ExtendedCSharpLanguage(Language lang)
	{
		super(lang);
	}
	
	/**
	 *	Constructs a new extended C# instance from TC's singleton C# language instance.
	 **/
	public ExtendedCSharpLanguage()
	{
		super(CSharpLanguage.CSHARP_LANGUAGE);
	}
	
	/**
	 *	Returns at a class and method declaration, with a main method that has testing code.
	 **/
	public Skeleton getSkeleton(ProblemComponent comp)
	{
		
		String skeleton = "using System;\n";
		skeleton += "using System.Collections;\n";
		skeleton += "using System.Collections.Specialized;\n";
		skeleton += "using System.Text;\n";
		skeleton += "using System.Text.RegularExpressions;\n";
		skeleton += "\npublic class " + comp.getClassName() + "\n{\n";
		skeleton += "\tpublic " + comp.getReturnType(getId()) + " " + comp.getMethodName() + "(";
		String[] paramNames = comp.getParamNames();
		DataType[] paramTypes = comp.getParamTypes();
		skeleton += paramTypes[0].getDescriptor(this) + " " + paramNames[0];
		for (int i=1; i<paramNames.length; i++)
			skeleton += ", " + paramTypes[i].getDescriptor(this) + " " + paramNames[i];
		skeleton += ")\n\t{\n";
		skeleton += "\t\t\n";
		int caret = skeleton.length()-1;
		skeleton += "\t}\n\t\n";
		skeleton += "\t[STAThread]\n";
		skeleton += "\tpublic static void Main(string[] args)\n\t{\n";
		TestCase[] cases = comp.getTestCases();
		//skeleton += "\t\tlong time;\n";
		String returnType = comp.getReturnType().getDescriptor(this);
		skeleton += "\t\t" + returnType + " answer;\n";
		skeleton += "\t\tbool errors = false;\n";
		boolean stringType = returnType.toLowerCase().startsWith("string");
		skeleton += "\t\tstring answerString, desiredAnswerString;\n\t\t\n";
		for (int i=0; i<cases.length; i++)
		{
			//skeleton += "\t\ttime = System.currentTimeMillis();\n";
			skeleton += "\t\tanswer = new " + comp.getClassName() + "()." + comp.getMethodName() + "(" + toTest(cases[i], paramTypes) + ");\n";;
			//skeleton += "\t\tSystem.out.println(\"Time: \" + (System.currentTimeMillis()-time)/1000.0 + \" seconds\");\n";
			skeleton += "\t\tConsole.WriteLine(\"Your answer:\");\n";
			if (returnType.endsWith("[]"))
			{
				skeleton += "\t\tanswerString = \"{ \";\n";
				skeleton += "\t\tif (answer.Length > 0)\n";
				skeleton += "\t\t{\n";
				skeleton += "\t\t\tanswerString += " + (stringType ? "\"\\\"\" + " : "") + "answer[0]" + (stringType ? " + \"\\\"\"" : "") + ";\n";
				skeleton += "\t\t\tfor (int i=1; i<answer.Length; i++)\n";
				skeleton += "\t\t\t\tanswerString += \",  " + (stringType ? "\\\"" : "") + "\" + answer[i]" + (stringType ? " + \"\\\"\"" : "") + ";\n";
				skeleton += "\t\t\tanswerString += \" }\"\n";
				skeleton += "\t\t}\n";
				skeleton += "\t\telse\n";
				skeleton += "\t\t\tanswerString += \"}\";\n";
			}
			else
				skeleton += "\t\tanswerString = \"" + (stringType ? "\\\"" : "") +"\" + answer" + (stringType ? " + \"\\\"\"" : "") + ";\n";
			skeleton += "\t\tConsole.WriteLine(\"\\t\" + answerString);\n";
			//If writing code that writes code isn't confusing enough, maybe writing code that writes code that writes code-like constructs is.
			skeleton += "\t\tdesiredAnswerString = \"" + cases[i].getOutput().replaceAll("\\\"", "\\\\\\\"") + "\";\n";
			skeleton += "\t\tConsole.WriteLine(\"Desired answer:\\n\\t\" + desiredAnswerString);\n";
			skeleton += "\t\tif (answerString != desiredAnswerString)\n";
			skeleton += "\t\t{\n";
			skeleton += "\t\t\terrors = true;\n";
			skeleton += "\t\t\tConsole.WriteLine(\"DOESN'T MATCH!!!!\");\n";
			skeleton += "\t\t}\n";
			skeleton += "\t\telse\n";
			skeleton += "\t\t\tConsole.WriteLine(\"Match :-)\");\n";
			skeleton += "\t\tConsole.WriteLine();\n";
		}
		skeleton += "\t\t\n\t\tif (errors)\n";
		skeleton += "\t\t\tConsole.WriteLine(\"Some of the test cases had errors :-(\");\n";
		skeleton += "\t\telse\n";
		skeleton += "\t\t\tConsole.WriteLine(\"You're a stud (at least on the test data)! :-D \");\n";
		skeleton += "\t}\n}\n";
		skeleton += "\n//Powered by [KawigiEdit]\n";
		return new Skeleton(skeleton, caret);
	}
	
	/**
	 *	Quick utility function to provide the code that should return the answer.
	 **/
	private String toTest(TestCase test, DataType[] types)
	{
		String ret = "";
		String[] input = test.getInput();
		ret += translateObject(types[0].getDescriptor(this), input[0]);
		for (int i=1; i<input.length; i++)
			ret += ", " + translateObject(types[i].getDescriptor(this), input[i]);
		ret = ret.replaceAll("\\n", "");
		return ret;
	}
	
	/**
	 *	Quck utility function to convert a value to code that creates that value in Java.
	 **/
	private static String translateObject(String type, String value)
	{
		if (type.endsWith("[]"))
			return "new " + type + value;
		else
			return value;
	}
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.
	 **/
	public String getCompileCommand(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".compiler";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"C:\\WINDOWS\\Microsoft.NET\\Framework\\v1.1.4322\\csc\" $PROBLEM$.cs");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".run";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "\"$CWD$\\$PROBLEM$.exe\"");
		command = command.replaceAll("\\$CWD\\$", cwd.getPath());
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp)
	{
		LocalPreferences prefs = LocalPreferences.getInstance();
		String propname = "kawigi.language." + getPropertyClass() + ".filename";
		String command;
		if (prefs.getProperty(propname) != null)
			command = prefs.getProperty(propname);
		else
			prefs.setProperty(propname, command = "$PROBLEM$.cs");
		command = command.replaceAll("\\$PROBLEM\\$", comp.getClassName());
		return command;
	}
	
	/**
	 *	Returns the class of the C# implementation of a View
	 **/
	public Class getViewClass()
	{
		return CSharpView.class;
	}
	
	/**
	 *	Overrides the property class in LanguageContainer so that it only has alphanumeric characters.
	 **/
	public String getPropertyClass()
	{
		return "csharp";
	}
}