package kawigi.editor;
import javax.swing.*;
import javax.swing.text.*;
import com.topcoder.shared.language.*;
import kawigi.language.*;
import java.awt.*;

/**
 *	This class was originally just a hack on JTextPane to stop it from wrapping
 *	lines, as there is no setting or method to do this normally.
 *	
 *	It's also annoying, really.  Although using my own version of a JTextPane has
 *	come in useful since then, really the line wrapping is still the main special
 *	functionality in here.
 **/
public class NoWrapJTextPane extends JTextPane
{
	/**
	 *	Creates a new <code>NoWrapJTextPane</code> and sets it to use various 
	 *	versions of my EditorKit implementation based on a few mime types.
	 *	
	 *	The special mime types it will now know are text/Java, text/C++, text/C#
	 *	and text/VB.
	 **/
	public NoWrapJTextPane()
	{
		//This is a convenient way to do this :-)
		doContentType(ExtendedJavaLanguage.EXTENDED_JAVA_LANGUAGE);
		doContentType(ExtendedCPPLanguage.EXTENDED_CPP_LANGUAGE);
		doContentType(ExtendedCSharpLanguage.EXTENDED_CSHARP_LANGUAGE);
		doContentType(ExtendedVBLanguage.EXTENDED_VB_LANGUAGE);
	}
	
	/**
	 *	Given an ExtendedLanguage, creates an EditorKit that uses the appropriate
	 *	view class and sets it to use that editor kit for the mime type associated
	 *	with that lanugage (i.e. - text/<language name>).
	 **/
	private void doContentType(ExtendedLanguage lang)
	{
		setEditorKitForContentType("text/" + lang.getName(), new ConfigurableEditorKit(lang.getViewClass()));
	}
	
	/**
	 * It's brutally annoying that I have to write this, and sometimes it doesn't even quite work.
	 **/
	public boolean getScrollableTracksViewportWidth()
	{
		return getParent() instanceof JViewport && ((JViewport)getParent()).getWidth() >= getUI().getPreferredSize(this).width;	//all this to just not wrap?  Why isn't there some good way to set this already?
	}
	
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return orientation == SwingConstants.VERTICAL ? (int)visibleRect.getHeight()-getFont().getSize() : (int)visibleRect.getWidth()-getFont().getSize();
	}
	
	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return 3*getFont().getSize()/2;
	}
	
	/**
	 *	By default, use my GenericView to render the text.
	 *
	 *  This will be changed whenever someone looks at the problem in a specific language.
	 **/
	protected EditorKit createDefaultEditorKit()
	{
		//Hey!  Use my EditorKit!
		return new ConfigurableEditorKit(GenericView.class);
	}
}