package kawigi.challenge;
import javax.swing.*;
import java.awt.*;

public class TableViewer extends JPanel
{
	private GridBagLayout gridbag;
	private TableCell last;
	private GridBagConstraints c;
	
	public TableViewer()
	{
		gridbag = new GridBagLayout();
		setLayout(gridbag);
	}
	
	public void addCell(String text, int rowspan, int colspan)
	{
		c = new GridBagConstraints();
		c.gridwidth = colspan;
		c.gridheight = rowspan;
		c.fill = GridBagConstraints.BOTH;
		last = new TableCell(text);
		gridbag.setConstraints(last, c);
		add(last);
	}
	
	public void endRow()
	{
		if (c != null && last != null)
		{
			c.gridwidth = GridBagConstraints.REMAINDER;
			gridbag.setConstraints(last, c);
		}
	}
}