package kawigi.util;
import java.io.*;
import javax.swing.text.*;

/**
 *	I couldn't do local compiling and testing without this.
 *	
 *	This contains and manages a process and forwards its output using ProcessOutput
 *	objects.
 **/
public class ProcessContainer
{
	private Process p;
	private JTextComponent outputComponent;
	private ProcessOutput stdout, stderr;
	private int exitVal;
	private boolean done;
	
	/**
	 *	Creates a new ProcessContainer for p that forwards its standard output/error
	 *	streams into <code>output</code>.
	 *	
	 *	Note that it will clear output if it isn't already clear.
	 **/
	public ProcessContainer(Process p, JTextComponent output)
	{
		this.p = p;
		outputComponent = output;
		output.setText("");
	}
	
	/**
	 *	Starts the threads that listen to the output and error streams of the process.
	 **/
	public synchronized void start()
	{
		stdout = new ProcessOutput(p.getInputStream(), outputComponent);
		stderr = new ProcessOutput(p.getErrorStream(), outputComponent);
		stdout.start();
		stderr.start();
	}
	
	/**
	 *	Finishes and stores the exit value for the process.
	 **/
	public synchronized void waitFor()
	{
		try
		{
			exitVal = p.waitFor();
			done = true;
		}
		catch (InterruptedException ex)
		{
			outputComponent.setText(outputComponent.getText() + "***Interrupted***\n");
		}
	}
	
	/**
	 *	Returns true if this process has finished.
	 **/
	public synchronized boolean isDone()
	{
		return done || (stderr != null && stdout != null && stderr.isDone() && stdout.isDone());
	}
	
	/**
	 *	Forceably kills the process.
	 *	
	 *	You'll be glad sometimes that this option exists.
	 **/
	public void kill()
	{
		p.destroy();
	}
	
	/**
	 *	Returns the exit value of the process, waiting for it to finish if it hasn't yet.
	 **/
	public int endVal()
	{
		if (!done)
			waitFor();
		if (done)
			return exitVal;
		return -1;
	}
}
