package kawigi.challenge;

public class CoderHistory
{
	private int[] generalInfo;
	private int[][] challengeInfo;
	private int[][][] submissionInfo;
	private String name;
	public static final int RATING = 0, RANK = 1, COMPETITIONS = 2, VOLATILITY = 3, MAX_RATING = 4, MIN_RATING = 5, FAILED_CHALLENGE=0, FAILED_SYS=1, SUBMITTED=2, FAILED_CHALLENGES=0, CHALLENGES=1, DIV_I=0, DIV_II=1, LEVEL_ONE=0, LEVEL_2 = 1, LEVEL_3 = 2;
	
	public CoderHistory(String name, int[] generalInfo, int[][] div1info, int[][] div2info, int[][] challengeInfo)
	{
		this.name = name;
		this.generalInfo = generalInfo;
		submissionInfo = new int[][][]{div1info, div2info};
		this.challengeInfo = challengeInfo;
	}
	
	public String getName()
	{
		return name;
	}
	
	public int getRating()
	{
		return generalInfo[RATING];
	}
	
	public int getRank()
	{
		return generalInfo[RANK];
	}
	
	public int getNumCompetitions()
	{
		return generalInfo[COMPETITIONS];
	}
	
	public int getVolatility()
	{
		return generalInfo[VOLATILITY];
	}
	
	public int getMaxRating()
	{
		return generalInfo[MAX_RATING];
	}
	
	public int getMinRating()
	{
		return generalInfo[MIN_RATING];
	}
	
	public int getSubmissionInfo(int division, int level, int infoType)
	{
		return submissionInfo[division][level][infoType];
	}
	
	public int getChallengeInfo(int level, int type)
	{
		return challengeInfo[level][type];
	}
	
	public double getSubmissionAccuracy(int division, int level)
	{
		int[] line = submissionInfo[division][level];
		if (line[SUBMITTED] == 0)
			return 0;
		return (double)(line[SUBMITTED]-line[FAILED_CHALLENGE]-line[FAILED_SYS])/line[SUBMITTED];
	}
	
	public double getSubmissionChallengeability(int division, int level)
	{
		int[] line = submissionInfo[division][level];
		if (line[SUBMITTED] == 0)
			return 0;
		return (double)line[FAILED_CHALLENGE]/line[SUBMITTED];
	}
	
	public double getChallengeAccuracy(int level)
	{
		int[] line = challengeInfo[level];
		if (line[CHALLENGES] == 0)
			return 0;
		return (double)(line[CHALLENGES]-line[FAILED_CHALLENGES])/line[CHALLENGES];
	}
	
	public ProblemHistory getProblemHistory(int division, int level)
	{
		int[] line = submissionInfo[division][level];
		return new ProblemHistory(name, level+1, getSubmissionAccuracy(division, level), getSubmissionChallengeability(division, level));
	}
}