package kawigi.snippet;
import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Category extends JMenu implements Comparable, MenuElement, Serializable, ActionListener, MouseListener
{
	private Category parent;
	private transient JMenuItem deleteItem;
	private String name;
	private ArrayList snippets;
	
	public Category(String name)
	{
		super(name.length() == 0 ? "Snippets" : name);
		addMouseListener(this);
		this.name = name;
		snippets = new ArrayList();
	}
	
	public void add(Snippet s)
	{
		snippets.add(s);
		s.setCategory(this);
		Collections.sort(snippets);
		super.add(s);
	}
	
	public void remove(Snippet s)
	{
		snippets.add(s);
		super.remove(s);
	}
	
	public void remove(Category c)
	{
		snippets.remove(c);
		super.remove(c);
	}
	
	public void add(Category cat)
	{
		snippets.add(cat);
		cat.setCategory(this);
		Collections.sort(snippets);
		super.add(cat);
	}
	
	public void setCategory(Category cat)
	{
		parent = cat;
	}
	
	public void add(Snippet s, String cat)
	{
		while (cat.endsWith("/"))
			cat = cat.substring(0, cat.length()-1);
		while (cat.startsWith("/"))
			cat = cat.substring(1);
		if (cat.length() == 0)
			add(s);
		else if (cat.indexOf('/') >= 0)
		{
			String nextCat = cat.substring(0, cat.indexOf('/'));
			String rest = cat.substring(cat.indexOf('/')+1);
			for (int i=0; i<snippets.size(); i++)
				if (snippets.get(i) instanceof Category && ((Category)snippets.get(i)).getName().equals(nextCat))
				{
					((Category)snippets.get(i)).add(s, rest);
					return;
				}
			Category newcat = new Category(nextCat);
			add(newcat);
			newcat.add(s, rest);
		}
		else
		{
			for (int i=0; i<snippets.size(); i++)
				if (snippets.get(i) instanceof Category && ((Category)snippets.get(i)).getName().equals(cat))
				{
					Category c = ((Category)snippets.get(i));
					c.add(s);
					return;
				}
			Category newcat = new Category(cat);
			add(newcat);
			newcat.add(s);
		}
	}
	
	public String getName()
	{
		return name;
	}
	
	public String toString()
	{
		return name + "(" + snippets.size() + ")";
	}
	
	public void propagateActionListener(ActionListener al)
	{
		for (int i=0; i<snippets.size(); i++)
			if (snippets.get(i) instanceof Snippet)
				((Snippet)snippets.get(i)).addActionListener(al);
			else if (snippets.get(i) instanceof Category)
				((Category)snippets.get(i)).propagateActionListener(al);
	}
	
	public int compareTo(Object o)
	{
		if (o instanceof Snippet)
			return 1;
		String otherString = (o instanceof Snippet) ? ((Snippet)o).getName() : o.toString();
		return getName().compareTo(otherString);
	}
	
	public MenuElement[] getSubElements()
	{
		MenuElement[] ret = new MenuElement[snippets.size()];
		snippets.toArray(ret);
		return ret;
	}
	
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == deleteItem && parent != null)
			parent.remove(this);
	}
	
	public void mousePressed(MouseEvent e)
	{
		if (e.isPopupTrigger())
		{
			JPopupMenu popup = new JPopupMenu();
			if (deleteItem == null)
			{
				deleteItem = new JMenuItem("Delete");
				deleteItem.addActionListener(this);
			}
			popup.add(deleteItem);
			popup.show(this, e.getX(), e.getY());
		}
	}
	
	public void mouseReleased(MouseEvent e)
	{
		mousePressed(e);
	}
	
	public void mouseClicked(MouseEvent e){}
	public void mouseEntered(MouseEvent e){}
	public void mouseExited(MouseEvent e){}
}