package kawigi.language;
import com.topcoder.shared.language.*;
import com.topcoder.shared.problem.*;
import javax.swing.text.*;
import java.io.File;

/**
 *	Encapsulates a language with both KawigiEdit features and TC Language features.
 **/
public interface ExtendedLanguage extends Language
{
	/**
	 *	This should return at least a class and method declaration, and if possible, testing code
	 *	a directly executable method (like main in Java).
	 **/
	public String getSkeleton(ProblemComponent comp);
	
	/**
	 *	Returns the command that should be used to compile the file.
	 *	
	 *  Ideally, this won't be platform-specific, but realistically, some people use different
	 *	compilers than others completely.  It may be possible at some point to allow this to be
	 *	configured.  You may assume that the source file is in the current working directory.
	 **/
	public String getCompileCommand(ProblemComponent comp);
	
	/**
	 *	Returns the command that should be used to run the program and test cases.
	 *	
	 *	Again, some care will need to be taken to make this part platform-happy.  You may
	 *	assume that the code was compiled according to your compile command and that the
	 *	current working directory is the one where the source was saved.
	 **/
	public String getRunCommand(ProblemComponent comp, File cwd);
	
	/**
	 *	Returns the filename that the source file should be saved as.
	 *	
	 *	You may assume that this is the actual filename used when creating the compile and run
	 *	commands.
	 **/
	public String getFileName(ProblemComponent comp);
	
	/**
	 *	Returns a class compatible with javax.swing.text.View that can render the source
	 *	in this language.
	 **/
	public Class getViewClass();
}