package kawigi.config;
import javax.swing.*;
import java.awt.*;

/**
 *	A simple panel that has fields to enter a font face and size.
 **/
public class FontPanel extends JPanel
{
	private JComboBox facesBox;
	private JSpinner sizeSpinner;
	
	/**
	 *	Constructs a new FontPanel with f as the selected font.
	 **/
	public FontPanel(Font f)
	{
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		JPanel stuffPanel = new JPanel(new GridLayout(2, 1));
		JPanel labelPanel = new JPanel(new GridLayout(2, 1));
		facesBox = new JComboBox();
		Font[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
		for (int i=0; i<systemFonts.length; i++)
			facesBox.addItem(systemFonts[i].getName());
		facesBox.setSelectedItem(f.getName());
		sizeSpinner = new JSpinner(new SpinnerNumberModel(f.getSize(), 8, 72, 1));
		JLabel label1 = new JLabel("Font Face:");
		label1.setForeground(Color.white);
		labelPanel.add(label1);
		stuffPanel.add(facesBox);
		JLabel label2 = new JLabel("Size:");
		label2.setForeground(Color.white);
		labelPanel.add(label2);
		stuffPanel.add(sizeSpinner);
		add(labelPanel);
		add(stuffPanel);
	}
	
	/**
	 *	Returns the currently selected font, with plain decoration (not italic or bold)
	 **/
	public Font getSelectedFont()
	{
		return new Font(facesBox.getSelectedItem().toString(), Font.PLAIN, Integer.parseInt(sizeSpinner.getValue().toString()));
	}
}