package kawigi.challenge;
import java.util.Vector;

public class Tag
{
	private String identifier, originaltag, remainder;
	private boolean opentag, truetag, closetag;
	private Vector attributes;
	
	public Tag(String tag)
	{
		originaltag = tag;
		closetag = truetag = opentag = false;
		attributes = new Vector();
		while (Character.isWhitespace(tag.charAt(0)))
			tag = tag.substring(1);
		if (tag.charAt(0) == '<')
		{
			truetag = true;
			opentag = (tag.charAt(1) != '/');
			if (!opentag)
				tag = tag.substring(2);
			else
				tag = tag.substring(1);
			int endindex = tag.indexOf(' ');
			if (endindex < 0)
				endindex = tag.length();
			if (tag.indexOf('\t') < endindex && tag.indexOf('\t') >= 0)
				endindex = tag.indexOf('\t');
			if (tag.indexOf('\n') < endindex && tag.indexOf('\n') >= 0)
				endindex = tag.indexOf('\n');
			if (tag.indexOf('\r') < endindex && tag.indexOf('\r') >= 0)
				endindex = tag.indexOf('\r');
			if (tag.indexOf('>') < endindex && tag.indexOf('>') >= 0)
				endindex = tag.indexOf('>');
			identifier = tag.substring(0, endindex);
			tag = tag.substring(endindex);
			if (!opentag)
			{
				closetag = true;
				remainder = originaltag.substring(originaltag.indexOf('>')+1);
				originaltag = originaltag.substring(originaltag.indexOf('<'), originaltag.indexOf('>')+1);
				return;
			}
		}
		else
		{
			truetag = false;
			if (originaltag.indexOf('<')>=0)
			{
				remainder = originaltag.substring(originaltag.indexOf('<'));
				originaltag = originaltag.substring(0, originaltag.indexOf('<'));
			}
			return;
		}
		while (Character.isWhitespace(tag.charAt(0)))
			tag = tag.substring(1);
		while (tag.charAt(0) != '>')
		{
			Attribute temp = new Attribute(tag);
			if (temp.isValid())
			{
				tag = temp.getRemainder();
				while (Character.isWhitespace(tag.charAt(0)))
					tag = tag.substring(1);
				if (temp.isValid())
					attributes.addElement(temp);
				else
				{
					truetag = false;
					return;
				}
				if (tag.charAt(0) == '/' && tag.charAt(1) == '>')
				{
					tag = tag.substring(1);
					closetag = true;
				}
			}
			else
				tag = tag.substring(1);
		}
		remainder = tag.substring(1);
	}
	
	public Attribute getAttrAt(int index)
	{
		if (index <attributes.size())
			return (Attribute)attributes.elementAt(index);
		else
			return null;
	}
	
	public int numAttributes()
	{
		return attributes.size();
	}
	
	public boolean isText()
	{
		return !truetag;
	}
	
	public boolean isOpenTag()
	{
		return opentag && truetag;
	}
	
	public boolean isCloseTag()
	{
		return closetag && truetag;
	}
	
	public String getIdentifier()
	{
		return identifier;
	}
	
	public String getText()
	{
		if (!truetag)
			return originaltag;
		else
			return null;
	}
	
	public String getAttributeValue(String key)
	{
		for (int i=0; i<attributes.size(); i++)
		{
			if (key.equalsIgnoreCase(((Attribute)attributes.elementAt(i)).getName()))
				return ((Attribute)attributes.elementAt(i)).getValue();
		}
		return null;
	}
	
	public String toString()
	{
		if (truetag && closetag &! opentag)
			return "</" + identifier + ">";
		if (!truetag)
			return originaltag;
		String ret = "<" + identifier;
		for (int i=0; i<numAttributes(); i++)
			ret += " " + getAttrAt(i);
		if (closetag)
			return ret + " />";
		else
			return ret + ">";
	}
	
	public String getUnparsed()
	{
		return remainder;
	}
}
